/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.MockSSHClient;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

@MetadataInfo(onlyProps=true)
public class CliCommandExecutorTest {
    @Test
    public void testCopyRemoteToLocal(@TempDir File root, TestInfo testInfo) throws Exception {
        File mainDir = new File(root, testInfo.getTestMethod().map(Method::getName).orElse(""));
        FileUtils.forceMkdir((File)mainDir);
        File tmpDir = new File(mainDir, "from");
        File tempFile = new File(tmpDir, "temp-file.log");
        FileUtils.writeStringToFile((File)tempFile, (String)"abc");
        File targetDir = new File(mainDir, "to");
        MockSSHClient mockSSHClient = MockSSHClient.getInstance();
        CliCommandExecutor cliSpy = (CliCommandExecutor)Mockito.spy((Object)new CliCommandExecutor("localhost", "root", null));
        ((CliCommandExecutor)Mockito.doReturn((Object)((Object)mockSSHClient)).when((Object)cliSpy)).getSshClient();
        cliSpy.copyRemoteToLocal(tempFile.getAbsolutePath(), targetDir.getAbsolutePath());
        File[] fileList = targetDir.listFiles();
        Assert.assertNotNull((Object)fileList);
        Assert.assertEquals((long)1L, (long)fileList.length);
        Assert.assertEquals((Object)fileList[0].getName(), (Object)tempFile.getName());
    }

    @Test
    public void testCopyLocalToRemote(@TempDir File root, TestInfo testInfo) throws Exception {
        File mainDir = new File(root, testInfo.getTestMethod().map(Method::getName).orElse(""));
        FileUtils.forceMkdir((File)mainDir);
        File tmpDir = new File(mainDir, "from");
        File tempFile = new File(tmpDir, "temp-file.log");
        FileUtils.writeStringToFile((File)tempFile, (String)"abc");
        File targetDir = new File(mainDir, "to");
        MockSSHClient mockSSHClient = MockSSHClient.getInstance();
        CliCommandExecutor cliSpy = (CliCommandExecutor)Mockito.spy((Object)new CliCommandExecutor("localhost", "root", null));
        ((CliCommandExecutor)Mockito.doReturn((Object)((Object)mockSSHClient)).when((Object)cliSpy)).getSshClient();
        cliSpy.copyFile(tempFile.getAbsolutePath(), targetDir.getAbsolutePath());
        File[] fileList = targetDir.listFiles();
        Assert.assertNotNull((Object)fileList);
        Assert.assertEquals((long)1L, (long)fileList.length);
        Assert.assertEquals((Object)fileList[0].getName(), (Object)tempFile.getName());
    }

    @Test
    void testLargeOutputSlice() throws Exception {
        int maxCommandLineOutputLength = KylinConfig.getInstanceFromEnv().getMaxCommandLineOutputLength();
        Assertions.assertEquals((int)0x500000, (int)maxCommandLineOutputLength);
        CliCommandExecutor cliCommandExecutor = new CliCommandExecutor();
        CliCommandExecutor.CliCmdExecResult res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..1251}) && yes \"$line\" 2>/dev/null | head -n 5505 && echo 'testtail'", null);
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
        res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..111}) && yes \"$line\" 2>/dev/null | head -n 53248&& echo 'testtail'", null);
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
        res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..9}) && yes \"$line\" 2>/dev/null | head -n 525312&& echo 'testtail'", null);
        Assertions.assertEquals((int)maxCommandLineOutputLength, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
        res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..1251}) && yes \"$line\" 2>/dev/null | head -n 1000 && echo 'testtail'", null);
        int HEAD_TAIL_LEN = 18;
        Assertions.assertEquals((int)1252018, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
        res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..111}) && yes \"$line\" 2>/dev/null | head -n 10240&& echo 'testtail'", null);
        Assertions.assertEquals((int)1146898, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
        res = cliCommandExecutor.execute("echo 'testhead' && line=$(printf 'a%.0s' {1..9}) && yes \"$line\" 2>/dev/null | head -n 102400&& echo 'testtail'", null);
        Assertions.assertEquals((int)1024018, (int)res.getCmd().length());
        Assertions.assertTrue((boolean)res.getCmd().startsWith("testhead"));
        Assertions.assertTrue((boolean)res.getCmd().endsWith("testtail\n"));
    }
}

