/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.RawResourceTool;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.AuditLogReplayWorker;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.TransactionUsageException;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
@OverwriteProp(key="kylin.metadata.url", value="test@jdbc,driverClassName=org.h2.Driver,url=jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1;MODE=MYSQL,username=sa,password=")
public class AuditReplayWorkerTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditReplayWorkerTest.class);

    @Test
    void testStartSchedule() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        replayWorker.startSchedule(2L, true);
        Assertions.assertEquals((long)2L, (long)auditLogStore.getLogOffset());
        replayWorker.startSchedule(3L, false);
        Assertions.assertEquals((long)3L, (long)auditLogStore.getLogOffset());
        replayWorker.close(true);
        auditLogStore.close();
    }

    @Test
    void testRestoreUpdateOffset() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        replayWorker.updateOffset(101L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        replayWorker.updateOffset(99L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        replayWorker.close(true);
        auditLogStore.close();
    }

    @Test
    void testRestoreHasCatchUp() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        replayWorker.updateOffset(101L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        Boolean hasCatch = (Boolean)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"hasCatch", (Object[])new Object[]{100L});
        Assertions.assertNotNull((Object)hasCatch);
        Assertions.assertTrue((boolean)hasCatch);
        Boolean hasCatchFalse = (Boolean)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"hasCatch", (Object[])new Object[]{102L});
        Assertions.assertNotNull((Object)hasCatchFalse);
        Assertions.assertFalse((boolean)hasCatchFalse);
        replayWorker.close(true);
        auditLogStore.close();
    }

    @Test
    void testCatchupInternal_Stopped() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        replayWorker.updateOffset(101L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        AtomicBoolean isStopped = (AtomicBoolean)ReflectionTestUtils.getField((Object)replayWorker, (String)"isStopped");
        Assertions.assertNotNull((Object)isStopped);
        isStopped.set(true);
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"catchupInternal", (Object[])new Object[]{1});
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        replayWorker.close(true);
        auditLogStore.close();
    }

    @Test
    void testCatchupInternal_TransactionUsageException() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        replayWorker.updateOffset(101L);
        Assertions.assertEquals((long)101L, (long)auditLogStore.getLogOffset());
        AtomicBoolean isStopped = (AtomicBoolean)ReflectionTestUtils.getField((Object)replayWorker, (String)"isStopped");
        Assertions.assertNotNull((Object)isStopped);
        isStopped.set(false);
        AuditLogReplayWorker replayWorkerSpy = (AuditLogReplayWorker)Mockito.spy((Object)replayWorker);
        ((AuditLogReplayWorker)Mockito.doThrow((Throwable[])new Throwable[]{new InvalidTimeoutException("xxxx", 123)}).when((Object)replayWorkerSpy)).catchupToMaxId(1L);
        try {
            ReflectionTestUtils.invokeMethod((Object)replayWorkerSpy, (String)"catchupToMaxId", (Object[])new Object[]{1L});
            Assertions.fail();
        }
        catch (TransactionUsageException e) {
            Assertions.assertEquals((Object)"xxxx", (Object)e.getMessage());
        }
        replayWorker.close(true);
        auditLogStore.close();
    }

    @Test
    void testCatchupInternal_OtherException() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AuditLogReplayWorker replayWorkerSpy = (AuditLogReplayWorker)Mockito.spy((Object)replayWorker);
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorkerSpy, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(1L, 123L));
        Assertions.assertFalse((boolean)delayIdQueue.isEmpty());
        IllegalArgumentException exception = new IllegalArgumentException("xxxx");
        ((AuditLogReplayWorker)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)replayWorkerSpy)).catchupToMaxId(0L);
        ((AuditLogReplayWorker)Mockito.doNothing().when((Object)replayWorkerSpy)).handleReloadAll((Exception)exception);
        replayWorkerSpy.catchupInternal(0);
        Assertions.assertTrue((boolean)delayIdQueue.isEmpty());
        replayWorker.close(true);
    }

    @Test
    void testCollectReplayDelayedId_EmptyQueue() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        Assertions.assertNotNull((Object)replayWorker);
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"collectReplayDelayedId", (Object[])new Object[]{1});
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        Assertions.assertTrue((boolean)CollectionUtils.isEmpty((Collection)delayIdQueue));
        replayWorker.close(true);
    }

    @Test
    void testCollectReplayDelayedId_NotEmptyQueue() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(1L, System.currentTimeMillis()));
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(2L, System.currentTimeMillis()));
        List delayedId = (List)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"collectReplayDelayedId", (Object[])new Object[]{10});
        Assertions.assertEquals(Arrays.asList(1L, 2L), (Object)delayedId);
        replayWorker.close(true);
    }

    @Test
    void testCollectReplayDelayedId_MaxCount() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(1L, System.currentTimeMillis()));
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(2L, System.currentTimeMillis()));
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(3L, System.currentTimeMillis()));
        List delayedId = (List)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"collectReplayDelayedId", (Object[])new Object[]{2});
        Assertions.assertEquals(Arrays.asList(1L, 2L), (Object)delayedId);
        Assertions.assertEquals((int)3, (int)delayIdQueue.size());
        replayWorker.close(true);
    }

    @Test
    void testCollectReplayDelayedId_Timeout() {
        long timeout = TestUtils.getTestConfig().getEventualReplayDelayItemTimeout();
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(1L, System.currentTimeMillis() - timeout * 2L));
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(2L, System.currentTimeMillis()));
        delayIdQueue.add(new AuditLogReplayWorker.AuditIdTimeItem(3L, System.currentTimeMillis()));
        List delayedId = (List)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"collectReplayDelayedId", (Object[])new Object[]{2});
        Assertions.assertEquals(Arrays.asList(1L, 2L), (Object)delayedId);
        Assertions.assertEquals((int)2, (int)delayIdQueue.size());
        replayWorker.close(true);
    }

    @Test
    void testWaitMaxIdOk() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        Boolean maxIdOk = (Boolean)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"waitMaxIdOk", (Object[])new Object[]{100L, 100L});
        Assertions.assertNotNull((Object)maxIdOk);
        Assertions.assertTrue((boolean)maxIdOk);
        maxIdOk = (Boolean)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"waitMaxIdOk", (Object[])new Object[]{101L, 100L});
        Assertions.assertNotNull((Object)maxIdOk);
        Assertions.assertFalse((boolean)maxIdOk);
        TestUtils.getTestConfig().setProperty("kylin.auditlog.replay-need-consecutive-log", "false");
        maxIdOk = (Boolean)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"waitMaxIdOk", (Object[])new Object[]{101L, 100L});
        Assertions.assertNotNull((Object)maxIdOk);
        Assertions.assertTrue((boolean)maxIdOk);
        replayWorker.close(true);
    }

    @Test
    void testRecordStepAbsentIdList_EmptyList() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(100L, 150L);
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"recordStepAbsentIdList", (Object[])new Object[]{stepWin, Collections.EMPTY_LIST});
        Assertions.assertTrue((boolean)delayIdQueue.isEmpty());
        replayWorker.close(true);
    }

    @Test
    void testRecordStepAbsentIdList_SameLength() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(100L, 101L);
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"recordStepAbsentIdList", (Object[])new Object[]{stepWin, Collections.singletonList(new AuditLog(101L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(1L), Long.valueOf(1L), null, null, null, null, null, false))});
        Assertions.assertTrue((boolean)delayIdQueue.isEmpty());
        replayWorker.close(true);
    }

    @Test
    void testRecordStepAbsentIdList_SkipTooOldAudit() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(100L, 104L);
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        Long timeout = (Long)ReflectionTestUtils.getField((Object)replayWorker, (String)"idEarliestTimeoutMills");
        Assertions.assertNotNull((Object)timeout);
        List<AuditLog> auditLogs = Arrays.asList(new AuditLog(101L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis() - timeout * 2L), Long.valueOf(1L), null, null, null, null, null, false), new AuditLog(102L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis() - timeout * 2L), Long.valueOf(1L), null, null, null, null, null, false), new AuditLog(103L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis() - timeout * 2L), Long.valueOf(1L), null, null, null, null, null, false));
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"recordStepAbsentIdList", (Object[])new Object[]{stepWin, auditLogs});
        Assertions.assertTrue((boolean)delayIdQueue.isEmpty());
        replayWorker.close(true);
    }

    @Test
    void testRecordStepAbsentIdList_CollectAbsentId() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(99L, 104L);
        ConcurrentLinkedQueue delayIdQueue = (ConcurrentLinkedQueue)ReflectionTestUtils.getField((Object)replayWorker, (String)"delayIdQueue");
        Assertions.assertNotNull((Object)delayIdQueue);
        Long timeout = (Long)ReflectionTestUtils.getField((Object)replayWorker, (String)"idEarliestTimeoutMills");
        Assertions.assertNotNull((Object)timeout);
        List<AuditLog> auditLogs = Arrays.asList(new AuditLog(101L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis()), Long.valueOf(1L), null, null, null, null, null, false), new AuditLog(102L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis()), Long.valueOf(1L), null, null, null, null, null, false), new AuditLog(103L, "adaasd", RawResourceTool.createByteSource("adaasd"), Long.valueOf(System.currentTimeMillis()), Long.valueOf(1L), null, null, null, null, null, false));
        ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"recordStepAbsentIdList", (Object[])new Object[]{stepWin, auditLogs});
        Assertions.assertEquals(Arrays.asList(100L, 104L), delayIdQueue.stream().map(AuditLogReplayWorker.AuditIdTimeItem::getAuditLogId).collect(Collectors.toList()));
        replayWorker.close(true);
    }

    @Test
    void testFindAbsentId_EmptyList() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(99L, 104L);
        List result = (List)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"findAbsentId", (Object[])new Object[]{Collections.emptyList(), stepWin});
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEmpty());
        replayWorker.close(true);
    }

    @Test
    void testFindAbsentId_CollectId() {
        AuditLogReplayWorker replayWorker = this.getAuditLogReplayWorker();
        AbstractAuditLogReplayWorker.FixedWindow stepWin = new AbstractAuditLogReplayWorker.FixedWindow(99L, 104L);
        List result = (List)ReflectionTestUtils.invokeMethod((Object)replayWorker, (String)"findAbsentId", (Object[])new Object[]{Arrays.asList(101L, 104L), stepWin});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(100L, 102L, 103L), (Object)result);
        replayWorker.close(true);
    }

    private AuditLogReplayWorker getAuditLogReplayWorker() {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        return replayWorker;
    }
}

