/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.engine.PrepareSqlStateParam;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.util.PrepareSQLUtils;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtils {
    private static final Logger logger = LoggerFactory.getLogger(QueryUtils.class);

    public static boolean isPrepareStatementWithParams(SQLRequest sqlRequest) {
        return sqlRequest instanceof PrepareSqlRequest && ((PrepareSqlRequest)sqlRequest).getParams() != null && ((PrepareSqlRequest)sqlRequest).getParams().length > 0;
    }

    public static void fillInPrepareStatParams(SQLRequest sqlRequest, boolean pushdown) {
        KylinConfigExt kylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(sqlRequest.getProject()).getConfig();
        if (QueryUtils.isPrepareStatementWithParams(sqlRequest) && !kylinConfig.enableReplaceDynamicParams() && !pushdown) {
            PrepareSqlStateParam[] params = ((PrepareSqlRequest)sqlRequest).getParams();
            String filledSql = QueryContext.current().getMetrics().getCorrectedSql();
            try {
                filledSql = PrepareSQLUtils.fillInParams((String)filledSql, (PrepareSqlStateParam[])params);
            }
            catch (IllegalStateException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            QueryContext.current().getMetrics().setCorrectedSql(filledSql);
        }
    }

    public static void updateQueryContextSQLMetrics(String alternativeSql) {
        QueryContext queryContext = QueryContext.current();
        if (StringUtils.isEmpty((CharSequence)queryContext.getMetrics().getCorrectedSql()) && queryContext.getQueryTagInfo().isStorageCacheUsed()) {
            String defaultSchema = "DEFAULT";
            try {
                defaultSchema = new QueryExec(queryContext.getProject(), KylinConfig.getInstanceFromEnv()).getDefaultSchemaName();
            }
            catch (Exception e) {
                logger.warn("Failed to get connection, project: {}", (Object)queryContext.getProject(), (Object)e);
            }
            QueryParams queryParams = new QueryParams(NProjectManager.getProjectConfig((String)queryContext.getProject()), alternativeSql, queryContext.getProject(), queryContext.getLimit().intValue(), queryContext.getOffset().intValue(), defaultSchema, false);
            queryParams.setAclInfo(queryContext.getAclInfo());
            queryContext.getMetrics().setCorrectedSql(QueryUtil.massageSql((QueryParams)queryParams));
        }
        if (StringUtils.isEmpty((CharSequence)queryContext.getMetrics().getCorrectedSql())) {
            queryContext.getMetrics().setCorrectedSql(alternativeSql);
        }
        queryContext.getMetrics().setSqlPattern(queryContext.getMetrics().getCorrectedSql());
    }
}

