/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.rest.response.SQLResponse;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class QueryDetectResponse {
    @JsonProperty(value="is_exception")
    private boolean isException = false;
    @JsonProperty(value="exception_message")
    private String exceptionMessage;
    @JsonProperty(value="query_id")
    private String queryId;
    @JsonProperty(value="is_push_down")
    private boolean isPushDown = false;
    @JsonProperty(value="is_post_aggregation")
    private boolean isPostAggregation = false;
    @JsonProperty(value="is_table_index")
    private boolean isTableIndex = false;
    @JsonProperty(value="is_base_index")
    private boolean isBaseIndex = false;
    @JsonProperty(value="is_cache")
    private boolean isCache = false;
    @JsonProperty(value="is_constants")
    private boolean isConstants = false;
    @JsonProperty(value="realizations")
    private List<IndexInfo> realizations = Lists.newArrayList();

    public QueryDetectResponse buildExceptionResponse(SQLResponse sqlResponse) {
        this.isException = true;
        this.exceptionMessage = sqlResponse.getExceptionMessage();
        this.queryId = sqlResponse.getQueryId();
        this.isCache = sqlResponse.isHitExceptionCache();
        this.realizations = Lists.newArrayList();
        return this;
    }

    public QueryDetectResponse buildResponse(String project, SQLResponse sqlResponse, QueryContext queryContext) {
        List indexInfoList = sqlResponse.getNativeRealizations().stream().map(realization -> new IndexInfo().buildResponse((NativeQueryRealization)realization, project)).collect(Collectors.toList());
        boolean isConstantQuery = QueryHistory.EngineType.CONSTANTS.name().equals(sqlResponse.getEngineType());
        this.isException = sqlResponse.isException;
        this.exceptionMessage = sqlResponse.getExceptionMessage();
        this.queryId = sqlResponse.getQueryId();
        this.isPushDown = sqlResponse.isQueryPushDown();
        this.isPostAggregation = !sqlResponse.isQueryPushDown() && !isConstantQuery && !queryContext.getMetrics().isExactlyMatch();
        this.isTableIndex = indexInfoList.stream().anyMatch(IndexInfo::isTableIndex);
        this.isBaseIndex = indexInfoList.stream().anyMatch(IndexInfo::isBaseIndex);
        this.isCache = sqlResponse.isStorageCacheUsed();
        this.isConstants = isConstantQuery;
        this.realizations = indexInfoList;
        return this;
    }

    @Generated
    public boolean isException() {
        return this.isException;
    }

    @Generated
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public boolean isPushDown() {
        return this.isPushDown;
    }

    @Generated
    public boolean isPostAggregation() {
        return this.isPostAggregation;
    }

    @Generated
    public boolean isTableIndex() {
        return this.isTableIndex;
    }

    @Generated
    public boolean isBaseIndex() {
        return this.isBaseIndex;
    }

    @Generated
    public boolean isCache() {
        return this.isCache;
    }

    @Generated
    public boolean isConstants() {
        return this.isConstants;
    }

    @Generated
    public List<IndexInfo> getRealizations() {
        return this.realizations;
    }

    @Generated
    public void setException(boolean isException) {
        this.isException = isException;
    }

    @Generated
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setPushDown(boolean isPushDown) {
        this.isPushDown = isPushDown;
    }

    @Generated
    public void setPostAggregation(boolean isPostAggregation) {
        this.isPostAggregation = isPostAggregation;
    }

    @Generated
    public void setTableIndex(boolean isTableIndex) {
        this.isTableIndex = isTableIndex;
    }

    @Generated
    public void setBaseIndex(boolean isBaseIndex) {
        this.isBaseIndex = isBaseIndex;
    }

    @Generated
    public void setCache(boolean isCache) {
        this.isCache = isCache;
    }

    @Generated
    public void setConstants(boolean isConstants) {
        this.isConstants = isConstants;
    }

    @Generated
    public void setRealizations(List<IndexInfo> realizations) {
        this.realizations = realizations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDetectResponse)) {
            return false;
        }
        QueryDetectResponse other = (QueryDetectResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isException() != other.isException()) {
            return false;
        }
        String this$exceptionMessage = this.getExceptionMessage();
        String other$exceptionMessage = other.getExceptionMessage();
        if (this$exceptionMessage == null ? other$exceptionMessage != null : !this$exceptionMessage.equals(other$exceptionMessage)) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        if (this.isPushDown() != other.isPushDown()) {
            return false;
        }
        if (this.isPostAggregation() != other.isPostAggregation()) {
            return false;
        }
        if (this.isTableIndex() != other.isTableIndex()) {
            return false;
        }
        if (this.isBaseIndex() != other.isBaseIndex()) {
            return false;
        }
        if (this.isCache() != other.isCache()) {
            return false;
        }
        if (this.isConstants() != other.isConstants()) {
            return false;
        }
        List<IndexInfo> this$realizations = this.getRealizations();
        List<IndexInfo> other$realizations = other.getRealizations();
        return !(this$realizations == null ? other$realizations != null : !((Object)this$realizations).equals(other$realizations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryDetectResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isException() ? 79 : 97);
        String $exceptionMessage = this.getExceptionMessage();
        result = result * 59 + ($exceptionMessage == null ? 43 : $exceptionMessage.hashCode());
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        result = result * 59 + (this.isPushDown() ? 79 : 97);
        result = result * 59 + (this.isPostAggregation() ? 79 : 97);
        result = result * 59 + (this.isTableIndex() ? 79 : 97);
        result = result * 59 + (this.isBaseIndex() ? 79 : 97);
        result = result * 59 + (this.isCache() ? 79 : 97);
        result = result * 59 + (this.isConstants() ? 79 : 97);
        List<IndexInfo> $realizations = this.getRealizations();
        result = result * 59 + ($realizations == null ? 43 : ((Object)$realizations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueryDetectResponse(isException=" + this.isException() + ", exceptionMessage=" + this.getExceptionMessage() + ", queryId=" + this.getQueryId() + ", isPushDown=" + this.isPushDown() + ", isPostAggregation=" + this.isPostAggregation() + ", isTableIndex=" + this.isTableIndex() + ", isBaseIndex=" + this.isBaseIndex() + ", isCache=" + this.isCache() + ", isConstants=" + this.isConstants() + ", realizations=" + this.getRealizations() + ")";
    }

    @Generated
    public QueryDetectResponse(boolean isException, String exceptionMessage, String queryId, boolean isPushDown, boolean isPostAggregation, boolean isTableIndex, boolean isBaseIndex, boolean isCache, boolean isConstants, List<IndexInfo> realizations) {
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
        this.queryId = queryId;
        this.isPushDown = isPushDown;
        this.isPostAggregation = isPostAggregation;
        this.isTableIndex = isTableIndex;
        this.isBaseIndex = isBaseIndex;
        this.isCache = isCache;
        this.isConstants = isConstants;
        this.realizations = realizations;
    }

    @Generated
    public QueryDetectResponse() {
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class IndexInfo {
        @JsonProperty(value="model_id")
        private String modelId;
        @JsonProperty(value="model_alias")
        private String modelAlias;
        @JsonProperty(value="layout_id")
        private long layoutId;
        @JsonProperty(value="index_type")
        private String indexType;
        @JsonProperty(value="partial_match_model")
        private boolean partialMatchModel = false;
        @JsonProperty(value="valid")
        private boolean valid = true;
        @JsonProperty(value="is_table_index")
        private boolean isTableIndex = false;
        @JsonProperty(value="is_base_index")
        private boolean isBaseIndex = false;

        public IndexInfo buildResponse(NativeQueryRealization realization, String project) {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project).getIndexPlan(realization.getModelId());
            LayoutEntity layoutEntity = indexPlan == null ? null : indexPlan.getLayoutEntity(realization.getLayoutId());
            this.modelId = realization.getModelId();
            this.modelAlias = realization.getModelAlias();
            this.layoutId = realization.getLayoutId();
            this.indexType = realization.getType();
            this.partialMatchModel = realization.isPartialMatchModel();
            this.valid = realization.isValid();
            this.isTableIndex = IndexEntity.isTableIndex((long)realization.getLayoutId());
            this.isBaseIndex = layoutEntity != null && layoutEntity.isBaseIndex();
            return this;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public String getModelAlias() {
            return this.modelAlias;
        }

        @Generated
        public long getLayoutId() {
            return this.layoutId;
        }

        @Generated
        public String getIndexType() {
            return this.indexType;
        }

        @Generated
        public boolean isPartialMatchModel() {
            return this.partialMatchModel;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public boolean isTableIndex() {
            return this.isTableIndex;
        }

        @Generated
        public boolean isBaseIndex() {
            return this.isBaseIndex;
        }

        @Generated
        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Generated
        public void setModelAlias(String modelAlias) {
            this.modelAlias = modelAlias;
        }

        @Generated
        public void setLayoutId(long layoutId) {
            this.layoutId = layoutId;
        }

        @Generated
        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }

        @Generated
        public void setPartialMatchModel(boolean partialMatchModel) {
            this.partialMatchModel = partialMatchModel;
        }

        @Generated
        public void setValid(boolean valid) {
            this.valid = valid;
        }

        @Generated
        public void setTableIndex(boolean isTableIndex) {
            this.isTableIndex = isTableIndex;
        }

        @Generated
        public void setBaseIndex(boolean isBaseIndex) {
            this.isBaseIndex = isBaseIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexInfo)) {
                return false;
            }
            IndexInfo other = (IndexInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
                return false;
            }
            String this$modelAlias = this.getModelAlias();
            String other$modelAlias = other.getModelAlias();
            if (this$modelAlias == null ? other$modelAlias != null : !this$modelAlias.equals(other$modelAlias)) {
                return false;
            }
            if (this.getLayoutId() != other.getLayoutId()) {
                return false;
            }
            String this$indexType = this.getIndexType();
            String other$indexType = other.getIndexType();
            if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
                return false;
            }
            if (this.isPartialMatchModel() != other.isPartialMatchModel()) {
                return false;
            }
            if (this.isValid() != other.isValid()) {
                return false;
            }
            if (this.isTableIndex() != other.isTableIndex()) {
                return false;
            }
            return this.isBaseIndex() == other.isBaseIndex();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IndexInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            String $modelAlias = this.getModelAlias();
            result = result * 59 + ($modelAlias == null ? 43 : $modelAlias.hashCode());
            long $layoutId = this.getLayoutId();
            result = result * 59 + (int)($layoutId >>> 32 ^ $layoutId);
            String $indexType = this.getIndexType();
            result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
            result = result * 59 + (this.isPartialMatchModel() ? 79 : 97);
            result = result * 59 + (this.isValid() ? 79 : 97);
            result = result * 59 + (this.isTableIndex() ? 79 : 97);
            result = result * 59 + (this.isBaseIndex() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "QueryDetectResponse.IndexInfo(modelId=" + this.getModelId() + ", modelAlias=" + this.getModelAlias() + ", layoutId=" + this.getLayoutId() + ", indexType=" + this.getIndexType() + ", partialMatchModel=" + this.isPartialMatchModel() + ", valid=" + this.isValid() + ", isTableIndex=" + this.isTableIndex() + ", isBaseIndex=" + this.isBaseIndex() + ")";
        }

        @Generated
        public IndexInfo(String modelId, String modelAlias, long layoutId, String indexType, boolean partialMatchModel, boolean valid, boolean isTableIndex, boolean isBaseIndex) {
            this.modelId = modelId;
            this.modelAlias = modelAlias;
            this.layoutId = layoutId;
            this.indexType = indexType;
            this.partialMatchModel = partialMatchModel;
            this.valid = valid;
            this.isTableIndex = isTableIndex;
            this.isBaseIndex = isBaseIndex;
        }

        @Generated
        public IndexInfo() {
        }
    }
}

