/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCLogUploadTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GCLogUploadTask.class);
    private static final int NUMBER_OF_GC_LOG_FILES = 10;
    private static final String UPLOAD_ERROR = "Upload GC log failed.";
    private final FileSystem fs = HadoopUtil.getWorkingFileSystem();
    private final File logDir;
    private final Path remoteDir;

    public GCLogUploadTask() {
        this(new File(KylinConfig.getKylinHome(), "logs"));
    }

    public GCLogUploadTask(File path) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.logDir = path;
        this.remoteDir = new Path(kylinConfig.getHdfsWorkingDirectory(), "_logs/" + AddressUtil.getHostName() + "/");
        this.init();
    }

    public void init() {
        try {
            if (!this.fs.exists(this.remoteDir)) {
                this.fs.mkdirs(this.remoteDir);
            }
        }
        catch (IOException e) {
            log.error("Failed to init logs folder at local and remote, ", (Throwable)e);
        }
    }

    @Override
    public void run() {
        log.trace("Start upload GC log");
        try {
            String fileName;
            String gcLogPrefix = "kylin.gc.pid" + ToolUtil.getKylinPid() + ".";
            String currentGCLogSuffix = ".current";
            File[] gcLogs = this.logDir.listFiles((dir, name) -> name.startsWith(gcLogPrefix));
            FileStatus[] remoteGClogs = this.fs.listStatus(this.remoteDir, path -> path.getName().startsWith(gcLogPrefix));
            if (null == gcLogs || gcLogs.length == 0) {
                log.error("Upload GC log failed. Cannot find GC log for pid: " + ToolUtil.getKylinPid());
                return;
            }
            int localGcNum = -1;
            int remoteGcNum = -1;
            for (File file : gcLogs) {
                fileName = file.getName();
                if (!fileName.endsWith(currentGCLogSuffix)) continue;
                localGcNum = Integer.parseInt(fileName.split("\\.")[3]);
                break;
            }
            if (localGcNum == -1) {
                log.error("Upload GC log failed. Cannot find current GC log!");
                return;
            }
            for (File file : remoteGClogs) {
                fileName = file.getPath().getName();
                if (!fileName.endsWith(currentGCLogSuffix)) continue;
                remoteGcNum = Integer.parseInt(fileName.split("\\.")[3]);
                break;
            }
            if (remoteGcNum != -1) {
                this.fs.delete(new Path(this.remoteDir, gcLogPrefix + remoteGcNum + currentGCLogSuffix), false);
            } else {
                remoteGcNum = 0;
            }
            if (localGcNum < remoteGcNum) {
                localGcNum += 10;
            }
            for (int cur = remoteGcNum; cur <= localGcNum; ++cur) {
                String curFileName;
                int realCur = cur % 10;
                if (cur == localGcNum) {
                    curFileName = gcLogPrefix + realCur + currentGCLogSuffix;
                    String string = gcLogPrefix + realCur;
                    if (this.fs.exists(new Path(this.remoteDir, string))) {
                        this.fs.delete(new Path(this.remoteDir, string), false);
                    }
                } else {
                    curFileName = gcLogPrefix + realCur;
                }
                HadoopUtil.uploadFileToHdfs((File)new File(this.logDir, curFileName), (Path)this.remoteDir);
            }
            log.trace("Upload GC log successful");
        }
        catch (Exception e) {
            log.error(UPLOAD_ERROR, (Throwable)e);
        }
    }
}

