/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.loader.AddToClassPathAction;
import org.apache.kylin.loader.ParserClassLoader;
import org.apache.kylin.loader.ParserClassLoaderState;
import org.apache.kylin.metadata.jar.JarInfo;
import org.apache.kylin.metadata.jar.JarInfoManager;
import org.apache.kylin.metadata.jar.JarTypeEnum;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.DataParserInfo;
import org.apache.kylin.metadata.streaming.DataParserManager;
import org.apache.kylin.parser.AbstractDataParser;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomFileService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomFileService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    public Set<String> uploadJar(MultipartFile jarFile, String project, String jarType) {
        this.aclEvaluate.checkProjectWritePermission(project);
        JarTypeEnum.validate((String)jarType);
        this.checkJarLegal(jarFile, project, jarType);
        return this.uploadStreamingCustomJar(jarFile, project, jarType);
    }

    public String removeJar(String project, String jarName, String jarType) {
        this.aclEvaluate.checkProjectWritePermission(project);
        JarTypeEnum.validate((String)jarType);
        this.checkJarName(jarName);
        return this.removeStreamingCustomJar(project, jarName, jarType);
    }

    public Set<String> uploadStreamingCustomJar(MultipartFile jarFile, String project, String jarType) throws IOException {
        String jarPath = this.uploadCustomJar(jarFile, project, jarType);
        return this.loadParserJar(jarFile.getOriginalFilename(), jarPath, project);
    }

    public void checkJarLegal(MultipartFile jarFile, String project, String jarType) throws IllegalArgumentException {
        String jarName = jarFile.getOriginalFilename();
        this.checkJarName(jarName);
        long jarMaxSize = NProjectManager.getProjectConfig((String)project).getStreamingCustomJarSizeMB();
        if (jarFile.getSize() > jarMaxSize) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_JAR_TOO_LARGE, new Object[]{jarMaxSize});
        }
        JarInfo jarInfo = this.getManager(JarInfoManager.class, project).getJarInfo(JarTypeEnum.valueOf((String)jarType), jarName);
        if (Objects.nonNull(jarInfo)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_JAR_EXISTS, new Object[]{jarName});
        }
        log.info("The jar file [{}] can be loaded", (Object)jarName);
    }

    public String uploadCustomJar(MultipartFile jarFile, String project, String jarType) throws KylinException, IOException {
        String jarName = jarFile.getOriginalFilename();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String jarHdfsPath = CustomFileService.getJarPath(project, jarName, jarType);
        Path path = new Path(jarHdfsPath);
        try (FSDataOutputStream out = fs.create(path);){
            IOUtils.copyBytes((InputStream)jarFile.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        }
        catch (IOException e) {
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)path);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_UPLOAD_JAR_FAILED, (Throwable)e, new Object[0]);
        }
        log.info("uploaded jar file [{}] to [{}]", (Object)jarName, (Object)jarHdfsPath);
        return jarHdfsPath;
    }

    public Set<String> loadParserJar(String jarName, String jarHdfsPath, String project) throws IOException {
        Set<String> dataParserSet = null;
        try {
            Set<String> finalDataParserSet = dataParserSet = this.checkParserLegal(jarName, jarHdfsPath, project);
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                DataParserManager manager = this.getManager(DataParserManager.class, project);
                manager.initDefault();
                for (String className : finalDataParserSet) {
                    manager.createDataParserInfo(new DataParserInfo(project, className, jarName));
                }
                return null;
            }, (String)project);
        }
        catch (Exception e) {
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(jarHdfsPath));
            ExceptionUtils.rethrow((Throwable)e);
        }
        return dataParserSet;
    }

    public Set<String> checkParserLegal(String jarName, String jarPath, String project) {
        HashSet jarSet = Sets.newHashSet((Object[])new String[]{jarPath});
        HashSet newParserSet = Sets.newHashSet();
        AddToClassPathAction addAction = new AddToClassPathAction(Thread.currentThread().getContextClassLoader(), (Collection)jarSet);
        ParserClassLoader parserClassLoader = (ParserClassLoader)AccessController.doPrivileged(addAction);
        Object object = null;
        try {
            ServiceLoader<AbstractDataParser> loadParsers = ServiceLoader.load(AbstractDataParser.class, (ClassLoader)parserClassLoader);
            for (AbstractDataParser parser : loadParsers) {
                newParserSet.add(parser.getClass().getName());
                log.info("{} get parser: {}", (Object)jarName, (Object)parser.getClass().getName());
            }
        }
        catch (Throwable loadParsers) {
            object = loadParsers;
            throw loadParsers;
        }
        finally {
            if (parserClassLoader != null) {
                if (object != null) {
                    try {
                        parserClassLoader.close();
                    }
                    catch (Throwable loadParsers) {
                        ((Throwable)object).addSuppressed(loadParsers);
                    }
                } else {
                    parserClassLoader.close();
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)newParserSet)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_JAR_PARSERS_NOT_EXISTS, new Object[]{jarName});
        }
        this.initDefaultParser(project);
        Set existParserSet = this.getManager(DataParserManager.class, project).listDataParserInfo().stream().map(DataParserInfo::getClassName).collect(Collectors.toSet());
        for (String className : newParserSet) {
            if (!existParserSet.contains(className)) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_PARSER_EXISTS, new Object[]{jarName, className});
        }
        int limitCount = NProjectManager.getProjectConfig((String)project).getStreamingCustomParserLimit();
        int newCount = newParserSet.size();
        int existCount = existParserSet.size() - 1;
        if (existCount + newCount > limitCount) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_UPLOAD_PARSER_LIMIT, new Object[]{existCount, newCount, limitCount});
        }
        try {
            ParserClassLoaderState.getInstance((String)project).registerJars((Set)jarSet);
            JarInfo jarInfo = new JarInfo(project, jarName, jarPath, JarTypeEnum.STREAMING_CUSTOM_PARSER);
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> this.getManager(JarInfoManager.class, project).createJarInfo(jarInfo), (String)project);
        }
        catch (Exception e) {
            ParserClassLoaderState.getInstance((String)project).unregisterJar((Set)jarSet);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_LOAD_JAR_FAILED, (Throwable)e, new Object[0]);
        }
        return newParserSet;
    }

    public String removeStreamingCustomJar(String project, String jarName, String jarType) {
        JarTypeEnum.validate((String)jarType);
        String jarPath = CustomFileService.getJarPath(project, jarName, jarType);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.getManager(DataParserManager.class, project).removeJar(jarName);
            this.getManager(JarInfoManager.class, project).removeJarInfo(JarTypeEnum.valueOf((String)jarType), jarName);
            return null;
        }, (String)project);
        ParserClassLoaderState.getInstance((String)project).unregisterJar((Set)Sets.newHashSet((Object[])new String[]{jarPath}));
        HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(jarPath));
        log.info("remove jar {} success", (Object)jarPath);
        return jarName;
    }

    private static String getJarPath(String project, String jarFileName, String jarType) {
        return KylinConfig.getInstanceFromEnv().getHdfsCustomJarPath(project, jarType) + jarFileName;
    }

    private void checkJarName(String jarName) {
        if (StringUtils.endsWith((CharSequence)jarName, (CharSequence)".jar")) {
            return;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_JAR, new Object[]{jarName});
    }
}

