/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.handler.resourcegroup;

import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=100)
@Component
public class ResourceGroupDisabledValidator
implements IResourceGroupRequestValidator {
    @Override
    public void validate(ResourceGroupRequest request) {
        if (request.isResourceGroupEnabled()) {
            return;
        }
        ResourceGroupManager manager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (!request.isResourceGroupEnabled() && !manager.isResourceGroupEnabled()) {
            return;
        }
        if (CollectionUtils.isEmpty(request.getResourceGroupEntities()) && CollectionUtils.isEmpty(request.getKylinInstances()) && CollectionUtils.isEmpty(request.getResourceGroupMappingInfoList())) {
            return;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_DISABLE_FAILED, new Object[0]);
    }
}

