/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class KylinPropertySourceConfiguration
implements EnvironmentPostProcessor,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinPropertySourceConfiguration.class);
    private static final String SYSTEM_PROPERTY_PREFIX = "kylin.system.property.";
    private static final String SPRING_SESSION_CLEAN_CRON = "spring.session.jdbc.cleanup-cron";
    public static final String SPRING_SESSION_JDBC_CLEANUP_FLAG = "spring.session.jdbc.cleanup-flag";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().contains("bootstrap")) {
            return;
        }
        log.debug("use kylinconfig as spring properties");
        MutablePropertySources propertySources = environment.getPropertySources();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        StorageURL storageURL = kylinConfig.getMetadataUrl();
        if (storageURL.getScheme().equals("jdbc")) {
            JdbcUtil.datasourceParameters((StorageURL)storageURL).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> kylinConfig.setProperty("spring.datasource." + key, value.toString())));
        }
        PropertySource<String> source = new PropertySource<String>("kylin"){
            Properties properties;
            {
                this.properties = KylinConfig.getInstanceFromEnv().exportToProperties();
            }

            public Object getProperty(String name) {
                return this.properties.getProperty(name);
            }
        };
        this.setSystemProperty(kylinConfig.exportToProperties());
        this.discardJDBCCleanSessionProperties(kylinConfig);
        propertySources.addAfter("systemProperties", (PropertySource)source);
    }

    public void setSystemProperty(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(SYSTEM_PROPERTY_PREFIX)) continue;
            String propertyValue = properties.getProperty(propertyName);
            Unsafe.setProperty((String)propertyName.replaceFirst(SYSTEM_PROPERTY_PREFIX, ""), (String)propertyValue);
        }
    }

    public int getOrder() {
        return -2147482618;
    }

    public void discardJDBCCleanSessionProperties(KylinConfig kylinConfig) {
        if (kylinConfig.getSpringStoreType().equalsIgnoreCase(StoreType.JDBC.toString())) {
            log.info("Discard JDBC clean session properties.");
            Unsafe.setProperty((String)SPRING_SESSION_CLEAN_CRON, (String)"-");
            Unsafe.setProperty((String)SPRING_SESSION_JDBC_CLEANUP_FLAG, (String)"false");
        }
    }
}

