/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class AddInstanceColumnCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddInstanceColumnCLI.class);
    private static final String SHOW_COLUMNS_FROM_SQL = "SELECT column_name FROM information_schema.columns WHERE table_name='%s' and column_name='%s'";
    private static final String ADD_COL_TO_TABLE_SQL = "alter table %s add %s %s";
    private static final String INSTANCE = "instance";

    public static void main(String[] args) throws Exception {
        log.info("Start to add instance column to audit log...");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try (JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(kylinConfig);){
            String auditLogTable = auditLogStore.getTable();
            String checkSql = String.format(Locale.ROOT, SHOW_COLUMNS_FROM_SQL, auditLogTable, INSTANCE);
            String upgradeSql = String.format(Locale.ROOT, ADD_COL_TO_TABLE_SQL, auditLogTable, INSTANCE, "varchar(100)");
            AddInstanceColumnCLI.checkAndUpgrade(auditLogStore.getJdbcTemplate(), checkSql, upgradeSql);
        }
        log.info("Add instance column finished!");
        Unsafe.systemExit((int)0);
    }

    public static void checkAndUpgrade(JdbcTemplate jdbcTemplate, String checkSql, String upgradeSql) {
        List list = jdbcTemplate.queryForList(checkSql, String.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("Result of {} is empty, will execute {}", (Object)checkSql, (Object)upgradeSql);
            try {
                jdbcTemplate.execute(upgradeSql);
            }
            catch (Exception e) {
                log.error("Failed to execute upgradeSql: {}", (Object)upgradeSql, (Object)e);
            }
        } else {
            log.info("Result of {} is not empty, no need to upgrade.", (Object)checkSql);
        }
    }
}

