/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.HandleResult;
import org.apache.kylin.tool.daemon.HandleStateEnum;
import org.apache.kylin.tool.daemon.handler.AbstractCheckStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuicideStateHandler
extends AbstractCheckStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(SuicideStateHandler.class);

    @Override
    public HandleResult doHandle(CheckResult checkResult) {
        logger.info("Start to suicide ...");
        String pidFile = SuicideStateHandler.getKylinHome() + "/kgid";
        File file = new File(pidFile);
        try {
            if (Files.deleteIfExists(file.toPath())) {
                logger.info("Deleted file: {}", (Object)pidFile);
            } else {
                logger.warn("Can not delete the file: {}", (Object)pidFile);
            }
        }
        catch (IOException e) {
            logger.error("Failed to delete the file: {}", (Object)pidFile);
        }
        Unsafe.systemExit((int)0);
        return new HandleResult(HandleStateEnum.STOP_CHECK);
    }
}

