/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"spring.cloud.nacos.discovery.enabled"}, matchIfMissing=true)
@Component
public class NacosClusterManager
implements ClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosClusterManager.class);
    public static final List<String> SERVER_IDS = Arrays.asList(ClusterConstant.QUERY, ClusterConstant.DATA_LOADING, ClusterConstant.SMART, ClusterConstant.COMMON, ClusterConstant.OPS, ClusterConstant.RESOURCE);
    private final Registration registration;
    @Autowired
    private DiscoveryClient discoveryClient;

    public NacosClusterManager(Registration registration) {
        this.registration = registration;
    }

    @Override
    public String getLocalServer() {
        return this.registration.getHost() + ":" + this.registration.getPort();
    }

    @Override
    public List<ServerInfoResponse> getQueryServers() {
        return this.getServersByServerId(ClusterConstant.QUERY);
    }

    @Override
    public List<ServerInfoResponse> getServersFromCache() {
        return this.getServers();
    }

    @Override
    public List<ServerInfoResponse> getJobServers() {
        return this.getServersByServerId(ClusterConstant.DATA_LOADING);
    }

    @Override
    public List<ServerInfoResponse> getServers() {
        ArrayList<ServerInfoResponse> servers = new ArrayList<ServerInfoResponse>();
        for (String serverId : SERVER_IDS) {
            servers.addAll(this.getServersByServerId(serverId));
        }
        return servers;
    }

    @Override
    public ServerInfoResponse getServerById(String serverId) {
        List<ServerInfoResponse> servers = this.getServersByServerId(serverId);
        if (servers.isEmpty()) {
            return null;
        }
        return servers.get(0);
    }

    public List<ServerInfoResponse> getServersByServerId(String serverId) {
        if (!SERVER_IDS.contains(serverId)) {
            throw new KylinRuntimeException("Unexpected serverId: " + serverId);
        }
        ArrayList<ServerInfoResponse> servers = new ArrayList<ServerInfoResponse>();
        List instances = this.discoveryClient.getInstances(serverId);
        for (ServiceInstance instance : instances) {
            servers.add(new ServerInfoResponse(this.instance2ServerStr(instance), serverId));
        }
        return servers;
    }

    private String instance2ServerStr(@Nonnull ServiceInstance serviceInstance) {
        Preconditions.checkNotNull((Object)serviceInstance, (Object)"service instance is null");
        return serviceInstance.getHost() + ":" + serviceInstance.getPort();
    }
}

