/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.util.QueryHisStoreUtil;
import org.apache.kylin.metadata.recommendation.candidate.JdbcRawRecStore;
import org.apache.kylin.metadata.streaming.util.StreamingJobRecordStoreUtil;
import org.apache.kylin.metadata.streaming.util.StreamingJobStatsStoreUtil;
import org.apache.kylin.tool.garbage.AbstractComparableCleanTask;
import org.apache.kylin.tool.garbage.CleanTaskExecutorService;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.apache.kylin.tool.garbage.PriorityExecutor;
import org.apache.kylin.tool.garbage.SourceUsageCleaner;
import org.apache.kylin.tool.garbage.StorageCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutineToolHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutineToolHelper.class);

    private RoutineToolHelper() {
    }

    public static CompletableFuture<Void> cleanQueryHistoriesAsync(long timeout, TimeUnit timeUnit) {
        RoutineToolHelper.tryInitCleanTaskExecutorService();
        return CleanTaskExecutorService.getInstance().submit(new AbstractComparableCleanTask(){

            @Override
            public String getName() {
                return "cleanQueryHistoriesForAllProjects";
            }

            @Override
            protected void doRun() {
                QueryHisStoreUtil.cleanQueryHistory();
            }

            @Override
            public StorageCleaner.CleanerTag getCleanerTag() {
                return StorageCleaner.CleanerTag.ROUTINE;
            }
        }, timeout, timeUnit);
    }

    public static CompletableFuture<Void> cleanQueryHistoriesAsync() {
        return RoutineToolHelper.cleanQueryHistoriesAsync(KylinConfig.getInstanceFromEnv().getStorageCleanTaskTimeout(), TimeUnit.MILLISECONDS);
    }

    public static CompletableFuture<Void> cleanEventLog(final CleanType type, final String project) {
        RoutineToolHelper.tryInitCleanTaskExecutorService();
        return CleanTaskExecutorService.getInstance().submit(new AbstractComparableCleanTask(){

            @Override
            public String getName() {
                return "cleanEventLog";
            }

            @Override
            protected void doRun() {
                StorageCleaner.EventLogCleaner eventLogCleaner = new StorageCleaner.EventLogCleaner();
                if (type == CleanType.ALL) {
                    eventLogCleaner.cleanAllEventLog();
                } else if (type == CleanType.SPARDER) {
                    eventLogCleaner.cleanCurrentSparderEventLog();
                } else if (type == CleanType.SPARK) {
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
                    eventLogCleaner.cleanSparkEventLogs(project);
                } else {
                    throw new IllegalArgumentException("unknown clean type: " + (Object)((Object)type));
                }
            }

            @Override
            public StorageCleaner.CleanerTag getCleanerTag() {
                return StorageCleaner.CleanerTag.ROUTINE;
            }
        }, KylinConfig.getInstanceFromEnv().getStorageCleanTaskTimeout(), TimeUnit.MILLISECONDS);
    }

    public static void cleanStorageForRoutine() {
        RoutineToolHelper.tryInitCleanTaskExecutorService();
        CleanTaskExecutorService.getInstance().cleanStorageForRoutine(true, Collections.emptyList(), 0.0, 0);
    }

    private static void tryInitCleanTaskExecutorService() {
        CleanTaskExecutorService.getInstance().bindWorkingPool(() -> {
            log.warn("Init the cleaning task thread pool from thread {}.", (Object)Thread.currentThread().getName());
            return PriorityExecutor.newWorkingThreadPool("routine-tool-helper-pool", KylinConfig.getInstanceFromEnv().getStorageCleanTaskConcurrency());
        });
    }

    public static void cleanStreamingStats() {
        StreamingJobStatsStoreUtil.cleanStreamingJobStats();
        StreamingJobRecordStoreUtil.cleanStreamingJobRecord();
    }

    public static void deleteRawRecItems() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        List projectInstances = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().filter(projectInstance -> !projectInstance.isExpertMode()).collect(Collectors.toList());
        if (projectInstances.isEmpty()) {
            return;
        }
        try (SetThreadName ignored = new SetThreadName("DeleteRawRecItemsInDB", new Object[0]);){
            JdbcRawRecStore jdbcRawRecStore = new JdbcRawRecStore(KylinConfig.getInstanceFromEnv());
            jdbcRawRecStore.deleteOutdated();
        }
        catch (Exception e) {
            log.error("delete outdated advice fail: ", (Throwable)e);
        }
    }

    public static void cleanGlobalSourceUsage() {
        log.info("Start to clean up global meta");
        try {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                new SourceUsageCleaner().execute();
                return null;
            }, (String)"_global");
        }
        catch (Exception e) {
            log.error("Failed to clean global meta", (Throwable)e);
        }
        log.info("Clean up global meta finished");
    }

    public static void cleanMetaByProject(String projectName) {
        log.info("Start to clean up {} meta", (Object)projectName);
        try {
            boolean needAggressiveOpt = Arrays.stream(KylinConfig.getInstanceFromEnv().getProjectsAggressiveOptimizationIndex()).map(StringUtils::lowerCase).collect(Collectors.toList()).contains(StringUtils.toRootLowerCase((String)projectName));
            MetadataCleaner.clean(projectName, needAggressiveOpt);
        }
        catch (Exception e) {
            log.error("Project[{}] cleanup Metadata failed", (Object)projectName, (Object)e);
        }
        log.info("Clean up {} meta finished", (Object)projectName);
    }

    public static void cleanMeta(List<String> projectsToCleanup) {
        try {
            RoutineToolHelper.cleanGlobalSourceUsage();
            for (String projName : projectsToCleanup) {
                RoutineToolHelper.cleanMetaByProject(projName);
            }
            RoutineToolHelper.cleanQueryHistoriesAsync();
            RoutineToolHelper.cleanStreamingStats();
            RoutineToolHelper.deleteRawRecItems();
            System.out.println("Metadata cleanup finished");
        }
        catch (Exception e) {
            log.error("Metadata cleanup failed", (Throwable)e);
            System.out.println("\u001b[31mMetadata cleanup failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr\u001b[0m");
        }
    }

    public static enum CleanType {
        ALL,
        SPARDER,
        SPARK,
        DRY_RUN;

    }
}

