/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.shaded.com.google.common.base.Objects;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public final class OneWayMessage
extends RequestMessage {
    public OneWayMessage(ManagedBuffer body) {
        super(body);
    }

    @Override
    public Message.Type type() {
        return Message.Type.ONE_WAY_MESSAGE;
    }

    @Override
    public int encodedLength() {
        return 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt((int)this.body().size());
    }

    public static OneWayMessage decode(ByteBuf buf) {
        return OneWayMessage.decode(buf, true);
    }

    public static OneWayMessage decode(ByteBuf buf, boolean decodeBody) {
        buf.readInt();
        if (decodeBody) {
            return new OneWayMessage(new NettyManagedBuffer(buf));
        }
        return new OneWayMessage(NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hashCode(this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof OneWayMessage) {
            OneWayMessage o = (OneWayMessage)other;
            return super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("body", this.body()).toString();
    }
}

