/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.webconsole.plugins.event.internal.EventInfo;
import org.apache.felix.webconsole.plugins.event.internal.OsgiUtil;

public class EventCollector {
    private static final String PROPERTY_MAX_SIZE = "max.size";
    private static final int DEFAULT_MAX_SIZE = 250;
    private List eventInfos;
    private long startTime;
    private int maxSize;

    public EventCollector(Dictionary props) {
        this.clear();
        this.updateConfiguration(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EventInfo info) {
        if (info != null) {
            EventCollector eventCollector = this;
            synchronized (eventCollector) {
                this.eventInfos.add(info);
                if (this.eventInfos.size() > this.maxSize) {
                    this.eventInfos.remove(0);
                }
                if (this.eventInfos.size() == 1) {
                    this.startTime = info.received;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EventCollector eventCollector = this;
        synchronized (eventCollector) {
            this.eventInfos = new ArrayList();
            this.startTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEvents() {
        EventCollector eventCollector = this;
        synchronized (eventCollector) {
            return new ArrayList(this.eventInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Dictionary props) {
        this.maxSize = OsgiUtil.toInteger(props, PROPERTY_MAX_SIZE, 250);
        EventCollector eventCollector = this;
        synchronized (eventCollector) {
            while (this.eventInfos.size() > this.maxSize) {
                this.eventInfos.remove(0);
            }
        }
    }

    public long getStartTime() {
        return this.startTime;
    }
}

