/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.spi.CamelLogger;
import org.slf4j.LoggerFactory;

public class DeadLetterChannelBuilder
extends DefaultErrorHandlerBuilder {
    public DeadLetterChannelBuilder() {
    }

    public DeadLetterChannelBuilder(Endpoint deadLetter) {
        this.setDeadLetter(deadLetter);
        this.getRedeliveryPolicy().setLogExhausted(false);
    }

    public DeadLetterChannelBuilder(String uri) {
        this.setDeadLetterUri(uri);
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        DeadLetterChannelBuilder answer = new DeadLetterChannelBuilder();
        super.cloneBuilder(answer);
        return answer;
    }

    @Override
    public Processor getFailureProcessor() {
        if (this.failureProcessor == null) {
            SendProcessor child = new SendProcessor(this.deadLetter, ExchangePattern.InOnly);
            this.failureProcessor = new FatalFallbackErrorHandler((Processor)child, true);
        }
        return this.failureProcessor;
    }

    @Override
    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(DeadLetterChannel.class), LoggingLevel.ERROR);
    }

    @Override
    public String toString() {
        return "DeadLetterChannelBuilder(" + this.deadLetterUri + ")";
    }
}

