/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class RouteCoverageXmlParser {
    private RouteCoverageXmlParser() {
    }

    public static Document parseXml(final CamelContext camelContext, InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element el = doc.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                String id = el.getAttribute("id");
                if (id != null) {
                    try {
                        if ("route".equals(qName)) {
                            ManagedRouteMBean route = ((ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class)).getManagedRoute(id);
                            if (route != null) {
                                long total = route.getExchangesTotal();
                                el.setAttribute("exchangesTotal", "" + total);
                                long totalTime = route.getTotalProcessingTime();
                                el.setAttribute("totalProcessingTime", "" + totalTime);
                            }
                        } else if ("from".equals(qName)) {
                            Element parent = (Element)elementStack.peek();
                            if (parent != null) {
                                String routeId = parent.getAttribute("id");
                                ManagedRouteMBean route = ((ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class)).getManagedRoute(routeId);
                                if (route != null) {
                                    long total = route.getExchangesTotal();
                                    el.setAttribute("exchangesTotal", "" + total);
                                    long totalTime = route.getTotalProcessingTime();
                                    el.setAttribute("totalProcessingTime", "" + totalTime);
                                    el.setAttribute("index", "0");
                                }
                            }
                        } else {
                            ManagedProcessorMBean processor = ((ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class)).getManagedProcessor(id);
                            if (processor != null) {
                                long total = processor.getExchangesTotal();
                                el.setAttribute("exchangesTotal", "" + total);
                                long totalTime = processor.getTotalProcessingTime();
                                el.setAttribute("totalProcessingTime", "" + totalTime);
                                int index = processor.getIndex();
                                el.setAttribute("index", "" + index);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!"route".equals(qName)) {
                    el.removeAttribute("customId");
                }
                elementStack.push(el);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    el.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }
}

