/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.PromiseImpl;
import org.osgi.util.promise.Success;

final class ResolvedPromiseImpl<T>
extends PromiseImpl<T> {
    private final T value;

    ResolvedPromiseImpl(T value, PromiseFactory factory) {
        super(factory);
        this.value = value;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public Throwable getFailure() {
        return null;
    }

    @Override
    void result(PromiseImpl.Result<? super T> consumer) {
        consumer.accept(this.value, null);
    }

    public String toString() {
        return super.toString() + "[resolved: " + this.value + "]";
    }

    @Override
    public Promise<T> onFailure(Consumer<? super Throwable> failure) {
        Objects.requireNonNull(failure);
        return this;
    }

    @Override
    public <F> Promise<T> onFailure(Consumer<? super F> failure, Class<? extends F> failureType) {
        Objects.requireNonNull(failure);
        Objects.requireNonNull(failureType);
        return this;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        if (success == null) {
            return this.resolved(null);
        }
        return super.then(success, failure);
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        Objects.requireNonNull(recovery);
        return this;
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery, Class<?> failureType) {
        Objects.requireNonNull(recovery);
        Objects.requireNonNull(failureType);
        return this;
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        Objects.requireNonNull(recovery);
        return this;
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery, Class<?> failureType) {
        Objects.requireNonNull(recovery);
        Objects.requireNonNull(failureType);
        return this;
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        Objects.requireNonNull(fallback);
        return this;
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback, Class<?> failureType) {
        Objects.requireNonNull(fallback);
        Objects.requireNonNull(failureType);
        return this;
    }

    @Override
    public Promise<T> timeout(long millis) {
        return this;
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        return CompletableFuture.completedFuture(this.value);
    }
}

