/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.transaction.internal.NLS;
import org.apache.aries.transaction.internal.TransactionManagerService;
import org.apache.aries.transaction.internal.XidFactoryImpl;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogUtils {
    public static Logger log = LoggerFactory.getLogger(TransactionLogUtils.class);
    private static Pattern TX_FILE_NAME = Pattern.compile("(.*)_([0-9]+)\\.([^.]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyActiveTransactions(Dictionary<String, Object> oldConfiguration, Dictionary<String, ?> newConfiguration) throws ConfigurationException, IOException {
        boolean initialConfiguration = false;
        if (oldConfiguration == null) {
            oldConfiguration = new Hashtable<String, Object>();
            initialConfiguration = true;
        }
        if (oldConfiguration.get("aries.transaction.howl.logFileDir") == null) {
            oldConfiguration.put("aries.transaction.howl.logFileDir", newConfiguration.get("aries.transaction.howl.logFileDir"));
        }
        String oldLogDirectory = (String)oldConfiguration.get("aries.transaction.howl.logFileDir");
        String newLogDirectory = (String)newConfiguration.get("aries.transaction.howl.logFileDir");
        if (newLogDirectory == null || oldLogDirectory == null) {
            return false;
        }
        File oldDir = new File(oldLogDirectory);
        File newDir = new File(newLogDirectory);
        File transaction_1 = null;
        if (!oldDir.equals(newDir)) {
            TransactionLogUtils.deleteDirectory(newDir);
            transaction_1 = new File(oldDir, TransactionLogUtils.configuredTransactionLogName(oldConfiguration, 1));
        } else {
            transaction_1 = new File(oldDir, TransactionLogUtils.configuredTransactionLogName(oldConfiguration, 1));
            if (!transaction_1.exists() || transaction_1.length() == 0L) {
                oldConfiguration.put("aries.transaction.howl.logFileName", TransactionManagerService.getString(newConfiguration, "aries.transaction.howl.logFileName", "transaction"));
                oldConfiguration.put("aries.transaction.howl.logFileExt", TransactionManagerService.getString(newConfiguration, "aries.transaction.howl.logFileExt", "log"));
                transaction_1 = new File(oldDir, TransactionLogUtils.configuredTransactionLogName(newConfiguration, 1));
            }
        }
        if (!transaction_1.exists() || transaction_1.length() == 0L) {
            return false;
        }
        BaseTxLogConfig oldTxConfig = TransactionLogUtils.transactionLogFileConfig(transaction_1);
        BaseTxLogConfig newTxConfig = TransactionLogUtils.transactionLogFileConfig(newConfiguration);
        if (oldTxConfig == null || oldTxConfig.equals(newTxConfig)) {
            String newName;
            if (!oldDir.equals(newDir) && !oldDir.renameTo(newDir)) {
                log.warn(NLS.MESSAGES.getMessage("tx.log.problem.renaming", oldDir.getAbsolutePath()));
                return false;
            }
            String oldName = TransactionLogUtils.configuredTransactionLogName(oldConfiguration, 1);
            if (!oldName.equals(newName = TransactionLogUtils.configuredTransactionLogName(newConfiguration, 1))) {
                final Dictionary<String, Object> finalOldConfiguration = oldConfiguration;
                final Dictionary<String, ?> finalNewConfiguration = newConfiguration;
                final HashMap changes = new HashMap();
                newDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        Matcher matcher = TX_FILE_NAME.matcher(name);
                        if (matcher.matches() && matcher.group(1).equals(TransactionManagerService.getString(finalOldConfiguration, "aries.transaction.howl.logFileName", "transaction")) && matcher.group(3).equals(TransactionManagerService.getString(finalOldConfiguration, "aries.transaction.howl.logFileExt", "log"))) {
                            changes.put(name, String.format("%s_%d.%s", TransactionManagerService.getString(finalNewConfiguration, "aries.transaction.howl.logFileName", "transaction"), Integer.parseInt(matcher.group(2)), TransactionManagerService.getString(finalNewConfiguration, "aries.transaction.howl.logFileExt", "log")));
                        }
                        return false;
                    }
                });
                for (String old : changes.keySet()) {
                    new File(newDir, old).renameTo(new File(newDir, (String)changes.get(old)));
                }
                return true;
            }
            return false;
        }
        File backupDir = null;
        if (oldDir.equals(newDir)) {
            backupDir = new File(newLogDirectory + String.format("-%016x", System.currentTimeMillis()));
            if (!oldDir.renameTo(backupDir)) {
                log.warn(NLS.MESSAGES.getMessage("tx.log.problem.renaming", oldDir.getAbsolutePath()));
                return false;
            }
            oldConfiguration = TransactionLogUtils.copy(oldConfiguration);
            oldConfiguration.put("aries.transaction.howl.logFileDir", backupDir.getAbsolutePath());
        }
        log.info(NLS.MESSAGES.getMessage("tx.log.conversion", oldDir.getAbsolutePath(), newDir.getAbsolutePath()));
        oldConfiguration.put("aries.transaction.recoverable", newConfiguration.get("aries.transaction.recoverable"));
        oldConfiguration.put("aries.transaction.howl.maxLogFiles", Integer.toString(oldTxConfig.maxLogFiles));
        oldConfiguration.put("aries.transaction.howl.maxBlocksPerFile", Integer.toString(oldTxConfig.maxBlocksPerFile));
        oldConfiguration.put("aries.transaction.howl.bufferSize", Integer.toString(oldTxConfig.bufferSizeKBytes));
        String tmid1 = TransactionManagerService.getString(oldConfiguration, "aries.transaction.tmid", "org.apache.aries.transaction");
        XidFactoryImpl xidFactory1 = new XidFactoryImpl(tmid1.substring(0, Math.min(tmid1.length(), 64)).getBytes());
        String tmid2 = TransactionManagerService.getString(newConfiguration, "aries.transaction.tmid", "org.apache.aries.transaction");
        XidFactoryImpl xidFactory2 = new XidFactoryImpl(tmid2.substring(0, Math.min(tmid2.length(), 64)).getBytes());
        TransactionLog oldLog = null;
        TransactionLog newLog = null;
        try {
            oldLog = TransactionManagerService.createTransactionLog(oldConfiguration, xidFactory1);
            newLog = TransactionManagerService.createTransactionLog(newConfiguration, xidFactory2);
            if (!(oldLog instanceof HOWLLog)) {
                log.info(NLS.MESSAGES.getMessage("tx.log.notrecoverable", oldLogDirectory));
                boolean bl = false;
                return bl;
            }
            if (!(newLog instanceof HOWLLog)) {
                log.info(NLS.MESSAGES.getMessage("tx.log.notrecoverable", newLogDirectory));
                boolean bl = false;
                return bl;
            }
            HOWLLog from = (HOWLLog)oldLog;
            HOWLLog to = (HOWLLog)newLog;
            Collection<Recovery.XidBranchesPair> pairs = from.recover(xidFactory1);
            for (Recovery.XidBranchesPair xidBranchesPair : pairs) {
                log.info(NLS.MESSAGES.getMessage("tx.log.migrate.xid", xidBranchesPair.getXid()));
                for (TransactionBranchInfo branchInfo : xidBranchesPair.getBranches()) {
                    log.info(NLS.MESSAGES.getMessage("tx.log.migrate.xid.branch", branchInfo.getBranchXid(), branchInfo.getResourceName()));
                }
                to.prepare(xidBranchesPair.getXid(), new ArrayList<TransactionBranchInfo>(xidBranchesPair.getBranches()));
            }
            log.info(NLS.MESSAGES.getMessage("tx.log.migrate.complete", new Object[0]));
            TransactionLogUtils.deleteDirectory(backupDir);
            boolean bl = !pairs.isEmpty();
            return bl;
        }
        catch (Exception e) {
            log.error(NLS.MESSAGES.getMessage("exception.tx.log.migration", new Object[0]), (Throwable)e);
            if (backupDir != null) {
                TransactionLogUtils.deleteDirectory(newDir);
                backupDir.renameTo(oldDir);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (oldLog instanceof HOWLLog) {
                    ((HOWLLog)oldLog).doStop();
                }
                if (newLog instanceof HOWLLog) {
                    ((HOWLLog)newLog).doStop();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BaseTxLogConfig transactionLogFileConfig(File txFile) throws IOException {
        FileChannel channel = new RandomAccessFile(txFile, "r").getChannel();
        try {
            ByteBuffer bb = ByteBuffer.wrap(new byte[1024]);
            int read = channel.read(bb);
            if (read < 71) {
                BaseTxLogConfig baseTxLogConfig = null;
                return baseTxLogConfig;
            }
            bb.rewind();
            if (bb.getInt() != 1213159244) {
                BaseTxLogConfig baseTxLogConfig = null;
                return baseTxLogConfig;
            }
            bb.getInt();
            int bufferSizeKBytes = bb.getInt() / 1024;
            bb.getInt();
            bb.getInt();
            bb.getLong();
            bb.getShort();
            if (bb.getShort() != 18432) {
                BaseTxLogConfig baseTxLogConfig = null;
                return baseTxLogConfig;
            }
            bb.getShort();
            bb.getShort();
            bb.get();
            bb.getLong();
            bb.getLong();
            bb.getLong();
            int maxLogFiles = bb.getInt();
            int maxBlocksPerFile = bb.getInt();
            if (maxBlocksPerFile == Integer.MAX_VALUE) {
                maxBlocksPerFile = -1;
            }
            bb.getShort();
            BaseTxLogConfig baseTxLogConfig = new BaseTxLogConfig(maxLogFiles, maxBlocksPerFile, bufferSizeKBytes);
            return baseTxLogConfig;
        }
        finally {
            channel.close();
        }
    }

    private static BaseTxLogConfig transactionLogFileConfig(Dictionary<String, ?> configuration) throws ConfigurationException {
        BaseTxLogConfig result = new BaseTxLogConfig();
        result.maxLogFiles = TransactionManagerService.getInt(configuration, "aries.transaction.howl.maxLogFiles", 2);
        result.maxBlocksPerFile = TransactionManagerService.getInt(configuration, "aries.transaction.howl.maxBlocksPerFile", -1);
        result.bufferSizeKBytes = TransactionManagerService.getInt(configuration, "aries.transaction.howl.bufferSize", 4);
        return result;
    }

    private static String configuredTransactionLogName(Dictionary<String, ?> configuration, int number) throws ConfigurationException {
        String logFileName = TransactionManagerService.getString(configuration, "aries.transaction.howl.logFileName", "transaction");
        String logFileExt = TransactionManagerService.getString(configuration, "aries.transaction.howl.logFileExt", "log");
        return String.format("%s_%d.%s", logFileName, number, logFileExt);
    }

    private static Dictionary<String, Object> copy(Dictionary<String, Object> configuration) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Enumeration<String> keys = configuration.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            ((Dictionary)result).put(k, configuration.get(k));
        }
        return result;
    }

    private static boolean deleteDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    TransactionLogUtils.deleteDirectory(f);
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    private static class BaseTxLogConfig {
        public int maxLogFiles;
        public int maxBlocksPerFile;
        public int bufferSizeKBytes;

        public BaseTxLogConfig() {
        }

        public BaseTxLogConfig(int maxLogFiles, int maxBlocksPerFile, int bufferSizeKBytes) {
            this.maxLogFiles = maxLogFiles;
            this.maxBlocksPerFile = maxBlocksPerFile;
            this.bufferSizeKBytes = bufferSizeKBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseTxLogConfig that = (BaseTxLogConfig)o;
            if (this.maxLogFiles != that.maxLogFiles) {
                return false;
            }
            if (this.maxBlocksPerFile != that.maxBlocksPerFile) {
                return false;
            }
            return this.bufferSizeKBytes == that.bufferSizeKBytes;
        }

        public int hashCode() {
            int result = this.maxLogFiles;
            result = 31 * result + this.maxBlocksPerFile;
            result = 31 * result + this.bufferSizeKBytes;
            return result;
        }
    }
}

