/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotFileReader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFileReader.class);
    private final String snapshotPath;
    private final RaftClient.Listener<ApiMessageAndVersion> listener;
    private final KafkaEventQueue queue;
    private final CompletableFuture<Void> caughtUpFuture;
    private FileRecords fileRecords;
    private Iterator<FileLogInputStream.FileChannelRecordBatch> batchIterator;
    private final MetadataRecordSerde serde = new MetadataRecordSerde();
    private long lastOffset = -1L;
    private volatile OptionalLong highWaterMark = OptionalLong.empty();

    public SnapshotFileReader(String snapshotPath, RaftClient.Listener<ApiMessageAndVersion> listener) {
        this.snapshotPath = snapshotPath;
        this.listener = listener;
        this.queue = new KafkaEventQueue(Time.SYSTEM, new LogContext("[snapshotReaderQueue] "), "snapshotReaderQueue_", (EventQueue.Event)new ShutdownEvent());
        this.caughtUpFuture = new CompletableFuture();
    }

    public void startup() throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.queue.append(new EventQueue.Event(){
            final /* synthetic */ SnapshotFileReader this$0;
            {
                this.this$0 = this$0;
            }

            public void run() throws Exception {
                this.this$0.fileRecords = FileRecords.open((File)new File(this.this$0.snapshotPath), (boolean)false);
                this.this$0.batchIterator = this.this$0.fileRecords.batches().iterator();
                this.this$0.scheduleHandleNextBatch();
                future.complete(null);
            }

            public void handleException(Throwable e) {
                future.completeExceptionally(e);
                this.this$0.beginShutdown("startup error");
            }
        });
        future.get();
    }

    private void handleNextBatch() {
        if (!this.batchIterator.hasNext()) {
            this.beginShutdown("done");
            return;
        }
        FileLogInputStream.FileChannelRecordBatch batch = this.batchIterator.next();
        this.lastOffset = batch.lastOffset();
        if (!this.batchIterator.hasNext()) {
            this.highWaterMark = OptionalLong.of(this.lastOffset);
        }
        if (batch.isControlBatch()) {
            this.handleControlBatch(batch);
        } else {
            this.handleMetadataBatch(batch);
        }
        this.scheduleHandleNextBatch();
    }

    private void scheduleHandleNextBatch() {
        this.queue.append(new EventQueue.Event(){

            public void run() {
                SnapshotFileReader.this.handleNextBatch();
            }

            public void handleException(Throwable e) {
                log.error("Unexpected error while handling a batch of events", e);
                SnapshotFileReader.this.beginShutdown("handleBatch error");
            }
        });
    }

    public OptionalLong highWaterMark() {
        return this.highWaterMark;
    }

    private void handleControlBatch(FileLogInputStream.FileChannelRecordBatch batch) {
        for (Record record : batch) {
            try {
                short typeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
                ControlRecordType type = ControlRecordType.fromTypeId((short)typeId);
                switch (type) {
                    case LEADER_CHANGE: {
                        LeaderChangeMessage message = new LeaderChangeMessage();
                        message.read((Readable)new ByteBufferAccessor(record.value()), (short)0);
                        this.listener.handleLeaderChange(new LeaderAndEpoch(OptionalInt.of(message.leaderId()), batch.partitionLeaderEpoch()));
                        break;
                    }
                    default: {
                        log.error("Ignoring control record with type {} at offset {}", (Object)type, (Object)record.offset());
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.error("unable to read control record at offset {}", (Object)record.offset(), (Object)e);
            }
        }
    }

    private void handleMetadataBatch(FileLogInputStream.FileChannelRecordBatch batch) {
        ArrayList<ApiMessageAndVersion> messages = new ArrayList<ApiMessageAndVersion>();
        for (Record record : batch) {
            ByteBufferAccessor accessor = new ByteBufferAccessor(record.value());
            try {
                ApiMessageAndVersion messageAndVersion = this.serde.read((Readable)accessor, record.valueSize());
                messages.add(messageAndVersion);
            }
            catch (Throwable e) {
                log.error("unable to read metadata record at offset {}", (Object)record.offset(), (Object)e);
            }
        }
        this.listener.handleCommit((BatchReader)MemoryBatchReader.of(List.of(Batch.data((long)batch.baseOffset(), (int)batch.partitionLeaderEpoch(), (long)batch.maxTimestamp(), (int)batch.sizeInBytes(), messages)), reader -> {}));
    }

    public void beginShutdown(String reason) {
        if (reason.equals("done")) {
            this.caughtUpFuture.complete(null);
        } else {
            this.caughtUpFuture.completeExceptionally(new RuntimeException(reason));
        }
        this.queue.beginShutdown(reason);
    }

    @Override
    public void close() throws Exception {
        this.beginShutdown("closing");
        this.queue.close();
    }

    class ShutdownEvent
    implements EventQueue.Event {
        ShutdownEvent() {
        }

        public void run() throws Exception {
            if (SnapshotFileReader.this.fileRecords != null) {
                SnapshotFileReader.this.fileRecords.close();
                SnapshotFileReader.this.fileRecords = null;
            }
            SnapshotFileReader.this.batchIterator = null;
        }

        public void handleException(Throwable e) {
            log.error("shutdown error", e);
        }
    }
}

