/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Objects;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ControllerMutationQuota;
import org.apache.kafka.server.quota.ControllerMutationQuotaManager;

public abstract class AbstractControllerMutationQuota
implements ControllerMutationQuota {
    protected final Time time;
    protected long lastThrottleTimeMs = 0L;
    private long lastRecordedTimeMs = 0L;

    protected AbstractControllerMutationQuota(Time time) {
        this.time = Objects.requireNonNull(time, "time cannot be null");
    }

    protected void updateThrottleTime(QuotaViolationException e, long timeMs) {
        this.lastThrottleTimeMs = ControllerMutationQuotaManager.throttleTimeMs(e);
        this.lastRecordedTimeMs = timeMs;
    }

    @Override
    public int throttleTime() {
        if (this.lastThrottleTimeMs == 0L) {
            return 0;
        }
        long deltaTimeMs = this.time.milliseconds() - this.lastRecordedTimeMs;
        return Math.max(0, (int)(this.lastThrottleTimeMs - deltaTimeMs));
    }
}

