/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public abstract class AbstractStream<K, V> {
    protected final String name;
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final Set<String> subTopologySourceNodes;
    protected final GraphNode graphNode;
    protected final InternalStreamsBuilder builder;

    public AbstractStream(AbstractStream<K, V> stream) {
        this.name = stream.name;
        this.builder = stream.builder;
        this.keySerde = stream.keySerde;
        this.valueSerde = stream.valueSerde;
        this.subTopologySourceNodes = stream.subTopologySourceNodes;
        this.graphNode = stream.graphNode;
    }

    AbstractStream(String name, Serde<K> keySerde, Serde<V> valueSerde, Set<String> subTopologySourceNodes, GraphNode graphNode, InternalStreamsBuilder builder) {
        if (subTopologySourceNodes == null || subTopologySourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.name = name;
        this.builder = builder;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.subTopologySourceNodes = subTopologySourceNodes;
        this.graphNode = graphNode;
    }

    protected InternalTopologyBuilder internalTopologyBuilder() {
        return this.builder.internalTopologyBuilder;
    }

    Set<String> ensureCopartitionWith(Collection<? extends AbstractStream<K, ?>> otherStreams) {
        HashSet<String> allSourceNodes = new HashSet<String>(this.subTopologySourceNodes);
        for (AbstractStream<K, ?> other : otherStreams) {
            allSourceNodes.addAll(other.subTopologySourceNodes);
        }
        this.builder.internalTopologyBuilder.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(ValueJoiner<T1, T2, R> joiner) {
        return (value2, value1) -> joiner.apply(value1, value2);
    }

    static <K, T2, T1, R> ValueJoinerWithKey<K, T2, T1, R> reverseJoinerWithKey(ValueJoinerWithKey<K, T1, T2, R> joiner) {
        return (key, value2, value1) -> joiner.apply(key, value1, value2);
    }

    static <K, V, VR> ValueMapperWithKey<K, V, VR> withKey(ValueMapper<V, VR> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper can't be null");
        return (readOnlyKey, value) -> valueMapper.apply(value);
    }

    static <K, V1, V2, VR> ValueJoinerWithKey<K, V1, V2, VR> toValueJoinerWithKey(ValueJoiner<V1, V2, VR> valueJoiner) {
        Objects.requireNonNull(valueJoiner, "joiner can't be null");
        return (readOnlyKey, value1, value2) -> valueJoiner.apply(value1, value2);
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }
}

