/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataEventHandler;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePartitionMetadataStore
extends RemotePartitionMetadataEventHandler
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RemotePartitionMetadataStore.class);
    private Map<TopicIdPartition, RemotePartitionDeleteMetadata> idToPartitionDeleteMetadata = new ConcurrentHashMap<TopicIdPartition, RemotePartitionDeleteMetadata>();
    private Map<TopicIdPartition, RemoteLogMetadataCache> idToRemoteLogMetadataCache = new ConcurrentHashMap<TopicIdPartition, RemoteLogMetadataCache>();

    @Override
    public void handleRemoteLogSegmentMetadata(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Adding remote log segment: {}", (Object)remoteLogSegmentMetadata);
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = remoteLogSegmentId.topicIdPartition();
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache == null) {
            throw new IllegalStateException("No partition metadata found for : " + String.valueOf(topicIdPartition));
        }
        remoteLogMetadataCache.addCopyInProgressSegment(remoteLogSegmentMetadata);
    }

    @Override
    public void handleRemoteLogSegmentMetadataUpdate(RemoteLogSegmentMetadataUpdate rlsmUpdate) {
        log.debug("Updating remote log segment: {}", (Object)rlsmUpdate);
        RemoteLogSegmentId remoteLogSegmentId = rlsmUpdate.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = remoteLogSegmentId.topicIdPartition();
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache != null) {
            try {
                remoteLogMetadataCache.updateRemoteLogSegmentMetadata(rlsmUpdate);
            }
            catch (RemoteResourceNotFoundException e) {
                log.warn("Error occurred while updating the remote log segment.", (Throwable)e);
            }
        } else {
            throw new IllegalStateException("No partition metadata found for : " + String.valueOf(topicIdPartition));
        }
    }

    @Override
    public void handleRemotePartitionDeleteMetadata(RemotePartitionDeleteMetadata remotePartitionDeleteMetadata) {
        log.debug("Received partition delete state with: {}", (Object)remotePartitionDeleteMetadata);
        TopicIdPartition topicIdPartition = remotePartitionDeleteMetadata.topicIdPartition();
        this.idToPartitionDeleteMetadata.put(topicIdPartition, remotePartitionDeleteMetadata);
        if (remotePartitionDeleteMetadata.state() == RemotePartitionDeleteState.DELETE_PARTITION_FINISHED) {
            this.idToRemoteLogMetadataCache.remove(topicIdPartition);
            this.idToPartitionDeleteMetadata.remove(topicIdPartition);
        }
    }

    @Override
    public void clearTopicPartition(TopicIdPartition topicIdPartition) {
        this.idToRemoteLogMetadataCache.remove(topicIdPartition);
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        return this.getRemoteLogMetadataCache(topicIdPartition).listAllRemoteLogSegments();
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        return this.getRemoteLogMetadataCache(topicIdPartition).listRemoteLogSegments(leaderEpoch);
    }

    private RemoteLogMetadataCache getRemoteLogMetadataCache(TopicIdPartition topicIdPartition) throws RemoteResourceNotFoundException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache == null) {
            throw new RemoteResourceNotFoundException("No resource found for partition: " + String.valueOf(topicIdPartition));
        }
        if (!remoteLogMetadataCache.isInitialized()) {
            throw new ReplicaNotAvailableException("Remote log metadata cache is not initialized for partition: " + String.valueOf(topicIdPartition));
        }
        return remoteLogMetadataCache;
    }

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(TopicIdPartition topicIdPartition, long offset, int epochForOffset) throws RemoteStorageException {
        return this.getRemoteLogMetadataCache(topicIdPartition).remoteLogSegmentMetadata(epochForOffset, offset);
    }

    public Optional<RemoteLogSegmentMetadata> nextSegmentWithTxnIndex(TopicIdPartition topicIdPartition, int epoch, long offset) throws RemoteStorageException {
        return this.getRemoteLogMetadataCache(topicIdPartition).nextSegmentWithTxnIndex(epoch, offset);
    }

    public Optional<Long> highestLogOffset(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        return this.getRemoteLogMetadataCache(topicIdPartition).highestOffsetForEpoch(leaderEpoch);
    }

    @Override
    public void close() throws IOException {
        log.info("Clearing the entries from the store.");
        this.idToPartitionDeleteMetadata = Collections.emptyMap();
        this.idToRemoteLogMetadataCache = Collections.emptyMap();
    }

    @Override
    public void maybeLoadPartition(TopicIdPartition partition) {
        this.idToRemoteLogMetadataCache.computeIfAbsent(partition, idPartition -> new RemoteLogMetadataCache());
    }

    @Override
    public void markInitialized(TopicIdPartition partition) {
        this.idToRemoteLogMetadataCache.get(partition).markInitialized();
        log.trace("Remote log components are initialized for user-partition: {}", (Object)partition);
    }

    @Override
    public boolean isInitialized(TopicIdPartition topicIdPartition) {
        RemoteLogMetadataCache metadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        return metadataCache != null && metadataCache.isInitialized();
    }
}

