/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCoordinatorMetricsShard
implements CoordinatorMetricsShard {
    private static final Logger log = LoggerFactory.getLogger(GroupCoordinatorMetricsShard.class);
    private volatile Map<ClassicGroupState, Long> classicGroupGauges;
    private volatile Map<ConsumerGroup.ConsumerGroupState, Long> consumerGroupGauges;
    private final Map<ShareGroup.ShareGroupState, TimelineGaugeCounter> shareGroupGauges;
    private final Map<String, Sensor> globalSensors;
    private final TimelineGaugeCounter numOffsetsTimelineGaugeCounter;
    private final TimelineGaugeCounter numClassicGroupsTimelineCounter;
    private final TopicPartition topicPartition;

    public GroupCoordinatorMetricsShard(SnapshotRegistry snapshotRegistry, Map<String, Sensor> globalSensors, TopicPartition topicPartition) {
        Objects.requireNonNull(snapshotRegistry);
        this.numOffsetsTimelineGaugeCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.numClassicGroupsTimelineCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.classicGroupGauges = Collections.emptyMap();
        this.consumerGroupGauges = Collections.emptyMap();
        this.shareGroupGauges = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)ShareGroup.ShareGroupState.EMPTY), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ShareGroup.ShareGroupState.STABLE), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ShareGroup.ShareGroupState.DEAD), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L)))});
        this.globalSensors = Objects.requireNonNull(globalSensors);
        this.topicPartition = Objects.requireNonNull(topicPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.increment();
        }
    }

    public void setConsumerGroupGauges(Map<ConsumerGroup.ConsumerGroupState, Long> consumerGroupGauges) {
        this.consumerGroupGauges = consumerGroupGauges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.decrement();
        }
    }

    public long numOffsets() {
        return this.numOffsetsTimelineGaugeCounter.atomicLong.get();
    }

    public long numClassicGroups(ClassicGroupState state) {
        Long counter = this.classicGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numClassicGroups() {
        return this.classicGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public long numConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        Long counter = this.consumerGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numConsumerGroups() {
        return this.consumerGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public void record(String sensorName) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record();
        }
    }

    public void record(String sensorName, double val) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record(val);
        }
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitUpTo(long offset) {
        long value;
        TimelineLong timelineLong = this.numClassicGroupsTimelineCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numClassicGroupsTimelineCounter.timelineLong.get(offset);
            this.numClassicGroupsTimelineCounter.atomicLong.set(value);
        }
        timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numOffsetsTimelineGaugeCounter.timelineLong.get(offset);
            this.numOffsetsTimelineGaugeCounter.atomicLong.set(value);
        }
        this.shareGroupGauges.forEach((__, gaugeCounter) -> {
            long value;
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                value = gaugeCounter.timelineLong.get(offset);
            }
            gaugeCounter.atomicLong.set(value);
        });
    }

    public void setClassicGroupGauges(Map<ClassicGroupState, Long> classicGroupGauges) {
        this.classicGroupGauges = classicGroupGauges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumShareGroups(ShareGroup.ShareGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.shareGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                gaugeCounter.timelineLong.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumShareGroups(ShareGroup.ShareGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.shareGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                gaugeCounter.timelineLong.decrement();
            }
        }
    }

    public long numShareGroups(ShareGroup.ShareGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.shareGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            return gaugeCounter.atomicLong.get();
        }
        return 0L;
    }

    public long numShareGroups() {
        return this.shareGroupGauges.values().stream().mapToLong(timelineGaugeCounter -> timelineGaugeCounter.atomicLong.get()).sum();
    }

    public void onShareGroupStateTransition(ShareGroup.ShareGroupState oldState, ShareGroup.ShareGroupState newState) {
        if (newState != null) {
            switch (newState) {
                case EMPTY: {
                    this.incrementNumShareGroups(ShareGroup.ShareGroupState.EMPTY);
                    break;
                }
                case STABLE: {
                    this.incrementNumShareGroups(ShareGroup.ShareGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.incrementNumShareGroups(ShareGroup.ShareGroupState.DEAD);
                    break;
                }
                default: {
                    log.warn("Unknown new share group state: {}", (Object)newState);
                }
            }
        }
        if (oldState != null) {
            switch (oldState) {
                case EMPTY: {
                    this.decrementNumShareGroups(ShareGroup.ShareGroupState.EMPTY);
                    break;
                }
                case STABLE: {
                    this.decrementNumShareGroups(ShareGroup.ShareGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.decrementNumShareGroups(ShareGroup.ShareGroupState.DEAD);
                    break;
                }
                default: {
                    log.warn("Unknown previous share group state: {}", (Object)oldState);
                }
            }
        }
    }

    private static class TimelineGaugeCounter {
        final TimelineLong timelineLong;
        final AtomicLong atomicLong;

        public TimelineGaugeCounter(TimelineLong timelineLong, AtomicLong atomicLong) {
            this.timelineLong = timelineLong;
            this.atomicLong = atomicLong;
        }
    }
}

