/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005g!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0015\r\u0011\"\u0001b\u0011!A\u0007A!A!\u0002\u0013\u0011\u0007\"B5\u0001\t\u0003Q\u0007\u0002\u0003:\u0001\u0005\u0004%\taG:\t\u000f\u0005\u0015\u0001\u0001)A\u0005i\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\f!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011!\t\u0019\u0006\u0001C\u00017\u0005}\u0001\u0002CA+\u0001\u0011\u00051$a\b\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBA`\u0001\u0011%\u0011\u0011\u0019\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\"O-\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005Y\u0012B\u0001\u0016\u001c\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005QZT\"A\u001b\u000b\u0005q1$B\u0001\u00108\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\n\u0005q*$A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003e\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r+\u0014\u0001B;uS2L!!\u0012\"\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!A/[7f+\u0005I\u0005C\u0001&O\u001b\u0005Y%B\u0001\u0018M\u0015\tie'\u0001\u0004d_6lwN\\\u0005\u0003\u001f.\u0013A\u0001V5nK\u0006)A/[7fA\u0005A!M]8lKJLE-F\u0001T!\t\u0011C+\u0003\u0002VG\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013a\u00052s_.,'/\u00129pG\"\u001cV\u000f\u001d9mS\u0016\u0014X#A-\u0011\u0007\tRF,\u0003\u0002\\G\tIa)\u001e8di&|g\u000e\r\t\u0003EuK!AX\u0012\u0003\t1{gnZ\u0001\u0015EJ|7.\u001a:Fa>\u001c\u0007nU;qa2LWM\u001d\u0011\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014X#\u00012\u0011\u0007\tR6\r\u0005\u0002eM6\tQM\u0003\u0002Nk%\u0011q-\u001a\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006AR.\u001a;bI\u0006$\u0018MV3sg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\u001dYG.\u001c8paF\u0004\"\u0001\u000b\u0001\t\u000bEj\u0001\u0019A\u001a\t\u000byj\u0001\u0019\u0001!\t\u000b\u001dk\u0001\u0019A%\t\u000bEk\u0001\u0019A*\t\u000b]k\u0001\u0019A-\t\u000b\u0001l\u0001\u0019\u00012\u0002!Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001cX#\u0001;\u0011\tUL8p`\u0007\u0002m*\u00111i\u001e\u0006\u0002q\u0006!!.\u0019<b\u0013\tQhOA\u0002NCB\u0004\"\u0001`?\u000e\u00031K!A '\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019\u0001&!\u0001\n\u0007\u0005\r1D\u0001\nBYR,'\u000fU1si&$\u0018n\u001c8Ji\u0016l\u0017!E;og\u0016tG/S:s+B$\u0017\r^3tA\u0005y\u0011N\u001c4mS\u001eDGOU3rk\u0016\u001cH/\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB1u_6L7MC\u0002\u0002\u0016Y\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI\"a\u0004\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003AIgN\u001a7jO\"$(+Z9vKN$\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\"A\u0019!%a\t\n\u0007\u0005\u00152E\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\rM,(-\\5u)!\ti#!\u0011\u0002L\u0005=\u0003CBA\u0018\u0003c\t)$\u0004\u0002\u0002\u0014%!\u00111GA\n\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002@\u0005e\"\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBA\")\u0001\u0007\u0011QI\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042\u0001`A$\u0013\r\tI\u0005\u0014\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!!\u0014\u0015\u0001\u0004\t)$\u0001\u0007mK\u0006$WM]!oI&\u001b(\u000f\u0003\u0004\u0002RQ\u0001\raU\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006AR.Y=cKB\u0013x\u000e]1hCR,\u0017j\u001d:DQ\u0006tw-Z:\u0002)\rdW-\u0019:J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005\u0005\u00121\f\u0005\b\u0003;:\u0002\u0019AA0\u0003mIgN\u001a7jO\"$\u0018\t\u001c;feB\u000b'\u000f^5uS>t\u0017\n^3ngB)\u0011\u0011MA9\u007f:!\u00111MA7\u001d\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5?\u00051AH]8pizJ\u0011\u0001J\u0005\u0004\u0003_\u001a\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003g\n)HA\u0002TKFT1!a\u001c$\u00031\u0011W/\u001b7e%\u0016\fX/Z:u)\u0019\tY(!/\u0002<B9!%! \u0002\u0002\u0006U\u0015bAA@G\t1A+\u001e9mKJ\u0002B!a!\u0002\u0010:!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n2\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u001b\u000b9)A\u000bBYR,'\u000fU1si&$\u0018n\u001c8SKF,Xm\u001d;\n\t\u0005E\u00151\u0013\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\ti)a\"\u0011\u0011\u0005]\u0015\u0011UAR\u0003Sk!!!'\u000b\t\u0005m\u0015QT\u0001\b[V$\u0018M\u00197f\u0015\r\tyjI\u0001\u000bG>dG.Z2uS>t\u0017b\u0001>\u0002\u001aB\u0019A0!*\n\u0007\u0005\u001dFJ\u0001\u0003Vk&$\u0007\u0003BAV\u0003gsA!!,\u00020B\u0019\u0011QM\u0012\n\u0007\u0005E6%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u001b\u0003bBA/1\u0001\u0007\u0011q\f\u0005\u0007\u0003{C\u0002\u0019\u0001/\u0002\u0017\t\u0014xn[3s\u000bB|7\r[\u0001\u001dQ\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f)1\t\u0019-a4\u0002Z\u0006\r\u0018q]Au!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAe\u0019\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002N\u0006\u001d'AB#se>\u00148\u000fC\u0004\u0002Rf\u0001\r!a5\u0002\u001bI,\u0017/^3ti\"+\u0017\rZ3s!\u0011\t))!6\n\t\u0005]\u0017q\u0011\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\u0005m\u0017\u00041\u0001\u0002^\u0006\u0011\u0012\r\u001c;feB\u000b'\u000f^5uS>t'+Z:q!\u0011\t))a8\n\t\u0005\u0005\u0018q\u0011\u0002\u0017\u00032$XM\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK\"1\u0011Q]\rA\u0002q\u000bqb]3oi\n\u0013xn[3s\u000bB|7\r\u001b\u0005\b\u0003;J\u0002\u0019AA0\u0011\u001d\tY/\u0007a\u0001\u0003+\u000bq\u0002^8qS\u000et\u0015-\\3t\u0005fLEm\u001d")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final NodeToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public NodeToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionItem[]{item})));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        void request2 = var5_4;
        void topicNamesByIds2 = var6_5;
        this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)request2)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder)request2, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)topicNamesByIds2){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    errors = response.authenticationException() != null ? Errors.NETWORK_EXCEPTION : (response.versionMismatch() != null ? Errors.UNSUPPORTED_VERSION : this.$outer.kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse(response.requestHeader(), (AlterPartitionResponse)response.responseBody(), this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1));
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull(Predef$.MODULE$.$conforms()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    Errors apiError = Errors.forCode((short)partition.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Controller successfully handled AlterPartition request for ").append(tp).append(": ").append(partition).toString());
                    Errors errors = apiError;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LeaderRecoveryState.optionalOf((byte)partition.leaderRecoveryState())));
                        if (option instanceof Some) {
                            LeaderRecoveryState leaderRecoveryState = (LeaderRecoveryState)((Some)option).value();
                            partitionResponses.update((Object)tp, (Object)package$.MODULE$.Right().apply((Object)LeaderAndIsr$.MODULE$.apply(partition.leaderId(), partition.leaderEpoch(), (List<Object>)((List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.isr()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), List$.MODULE$.canBuildFrom())), leaderRecoveryState, partition.partitionEpoch())));
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Controller returned an invalid leader recovery state (").append(partition.leaderRecoveryState()).append(") for ").append(tp).append(": ").append(partition).toString());
                            partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)Errors.UNKNOWN_SERVER_ERROR));
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)apiError));
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable & scala.Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    boolean bl;
                    Either leaderAndIsrOrError = (Either)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    if (leaderAndIsrOrError instanceof Left) {
                        Errors error = (Errors)((Left)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().completeExceptionally(error.exception());
                    } else if (leaderAndIsrOrError instanceof Right) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().complete(leaderAndIsr);
                    } else {
                        throw new MatchError((Object)leaderAndIsrOrError);
                    }
                    return BoxesRunTime.boxToBoolean((boolean)bl);
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(item.leaderAndIsr().isrWithBrokerEpoch()).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch());
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(NodeToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

