/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.assertions;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.rest.httppart.RequestContent;

public class FluentRequestContentAssertion<R>
extends FluentObjectAssertion<RequestContent, R> {
    public FluentRequestContentAssertion(Assertion creator, RequestContent value, R returns) {
        super(creator, value, returns);
        this.setThrowable(BadRequest.class);
    }

    public FluentRequestContentAssertion(RequestContent value, R returns) {
        this((Assertion)null, value, returns);
    }

    public <T> FluentObjectAssertion<T, R> as(Class<T> type) {
        return new FluentObjectAssertion(this.valueAsType(type), this.returns());
    }

    public <T> FluentObjectAssertion<T, R> as(Type type, Type ... args) {
        return new FluentObjectAssertion(this.valueAsType(type, args), this.returns());
    }

    public FluentByteArrayAssertion<R> asBytes() {
        return new FluentByteArrayAssertion(this.valueAsBytes(), this.returns());
    }

    @Override
    public R is(String values) throws AssertionError {
        return this.asString().is(values);
    }

    public R isContains(String ... values) throws AssertionError {
        return this.asString().isContains(values);
    }

    public R isEmpty() {
        return this.asString().isEmpty();
    }

    public R isNotContains(String ... values) throws AssertionError {
        return this.asString().isNotContains(values);
    }

    public R isNotEmpty() {
        return this.asString().isNotEmpty();
    }

    @Override
    public FluentRequestContentAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentRequestContentAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentRequestContentAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentRequestContentAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentRequestContentAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private byte[] valueAsBytes() throws AssertionError {
        try {
            return ((RequestContent)this.value()).cache().asBytes();
        }
        catch (IOException e) {
            throw this.error(e, "Exception occurred during call.", new Object[0]);
        }
    }

    private <T> T valueAsType(Class<T> c) throws AssertionError {
        try {
            return ((RequestContent)this.value()).cache().as(c);
        }
        catch (IOException e) {
            throw this.error(e, "Exception occurred during call.", new Object[0]);
        }
    }

    private <T> T valueAsType(Type c, Type ... args) throws AssertionError {
        try {
            return ((RequestContent)this.value()).cache().as(c, args);
        }
        catch (IOException e) {
            throw this.error(e, "Exception occurred during call.", new Object[0]);
        }
    }

    @Override
    protected String valueAsString() throws AssertionError {
        try {
            return ((RequestContent)this.value()).cache().asString();
        }
        catch (IOException e) {
            throw this.error(e, "Exception occurred during call.", new Object[0]);
        }
    }
}

