/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.annotation.AnnotationGroup;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class AnnotationInfo<T extends Annotation> {
    private final Annotatable annotatable;
    final int rank;
    private T a;
    private final Supplier<List<MethodInfo>> methods = Utils.mem(() -> CollectionUtils.stream(this.a.annotationType().getMethods()).map(m -> MethodInfo.of(ReflectionUtils.info(this.a.annotationType()), m)).toList());

    public static <A extends Annotation> AnnotationInfo<A> of(Annotatable on, A value) {
        return new AnnotationInfo<A>(on, value);
    }

    private static int findRank(Object a) {
        return ClassInfo.of(a).getAllMethods().stream().filter(m -> m.hasName("rank") && m.hasReturnType(Integer.TYPE)).findFirst().map(m -> Utils.safe(() -> (int)((Integer)m.invoke(a, new Object[0])))).orElse(0);
    }

    AnnotationInfo(Annotatable on, T a) {
        this.annotatable = on;
        this.a = (Annotation)AssertionUtils.assertArgNotNull("a", a);
        this.rank = AnnotationInfo.findRank(a);
    }

    public Class<? extends Annotation> annotationType() {
        return this.a.annotationType();
    }

    public <A extends Annotation> AnnotationInfo<A> cast(Class<A> type) {
        return type.isInstance(this.a) ? this : null;
    }

    public boolean equals(Object o) {
        if (o instanceof AnnotationInfo) {
            AnnotationInfo o2 = (AnnotationInfo)o;
            return this.a.equals(o2.a);
        }
        return this.a.equals(o);
    }

    public Optional<Boolean> getBoolean(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Boolean.TYPE)).map(x -> (Boolean)x.invoke(this.a, new Object[0]));
    }

    public Optional<Class<?>[]> getClassArray(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Class[].class)).map(x -> x.invoke(this.a, new Object[0]));
    }

    public <T> Optional<Class<? extends T>[]> getClassArray(String methodName, Class<T> type) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Class[].class)).map(x -> (Class[])x.invoke(this.a, new Object[0])).filter(arr -> {
            for (Class c : arr) {
                if (type.isAssignableFrom(c)) continue;
                return false;
            }
            return true;
        }).map(x -> x);
    }

    public Optional<Class<?>> getClassValue(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Class.class)).map(x -> x.invoke(this.a, new Object[0]));
    }

    public <T> Optional<Class<? extends T>> getClassValue(String methodName, Class<T> type) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Class.class)).map(x -> (Class)x.invoke(this.a, new Object[0])).filter(type::isAssignableFrom).map(x -> x);
    }

    public Optional<Double> getDouble(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Double.TYPE)).map(x -> (Double)x.invoke(this.a, new Object[0]));
    }

    public Optional<Float> getFloat(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Float.TYPE)).map(x -> (Float)x.invoke(this.a, new Object[0]));
    }

    public Optional<Integer> getInt(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Integer.TYPE)).map(x -> (Integer)x.invoke(this.a, new Object[0]));
    }

    public Optional<Long> getLong(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(Long.TYPE)).map(x -> (Long)x.invoke(this.a, new Object[0]));
    }

    public Optional<MethodInfo> getMethod(String methodName) {
        return this.methods.get().stream().filter(x -> Utils.eq(methodName, x.getSimpleName())).findFirst();
    }

    public String getName() {
        return Utils.cns(this.a.annotationType());
    }

    public int getRank() {
        return this.rank;
    }

    public Optional<ClassInfo> getReturnType(String methodName) {
        return this.getMethod(methodName).map(x -> x.getReturnType());
    }

    public Optional<String> getString(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(String.class)).map(x -> Utils.s(x.invoke(this.a, new Object[0])));
    }

    public Optional<String[]> getStringArray(String methodName) {
        return this.getMethod(methodName).filter(x -> x.hasReturnType(String[].class)).map(x -> (String[])x.invoke(this.a, new Object[0]));
    }

    public Optional<String> getValue() {
        return this.getString("value");
    }

    public <V> Optional<V> getValue(Class<V> type, String name) {
        return this.methods.get().stream().filter(m -> Utils.eq(m.getName(), name) && Utils.eq(m.getReturnType().inner(), type)).map(m -> Utils.safe(() -> m.invoke(this.a, new Object[0]))).findFirst();
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return Utils.nn(this.a.annotationType().getAnnotation(type));
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean hasName(String value) {
        return Utils.eq(value, this.a.annotationType().getName());
    }

    public boolean hasSimpleName(String value) {
        return Utils.eq(value, this.a.annotationType().getSimpleName());
    }

    public T inner() {
        return this.a;
    }

    public <A extends Annotation> boolean isInGroup(Class<A> group) {
        AnnotationGroup x = this.a.annotationType().getAnnotation(AnnotationGroup.class);
        return Utils.nn(x) && x.value().equals(group);
    }

    public <A extends Annotation> boolean isType(Class<A> type) {
        return this.a.annotationType() == type;
    }

    protected FluentMap<String, Object> properties() {
        ClassInfoTyped<? extends Annotation> ca = ReflectionUtils.info(this.a.annotationType());
        FluentMap ja = CollectionUtils.mapb().sorted().buildFluent();
        ca.getDeclaredMethods().stream().forEach(x -> Utils.safeOptCatch(() -> {
            Object d;
            Object val = x.invoke(this.a, new Object[0]);
            if (!(!Utils.neq(val, d = x.inner().getDefaultValue()) || Utils.isArray(val) && CollectionUtils.length(val) == 0 && Utils.isArray(d) && CollectionUtils.length(d) == 0)) {
                return val;
            }
            return null;
        }, e -> ThrowableUtils.lm(e)).ifPresent(v -> ja.a(x.getName(), v)));
        return CollectionUtils.filteredBeanPropertyMap().a(Utils.s((Object)this.annotatable.getAnnotatableType()), this.annotatable.getLabel()).a("@" + ca.getNameSimple(), ja);
    }

    public String toSimpleString() {
        return "@" + Utils.cns(this.a.annotationType()) + "(on=" + this.annotatable.getLabel() + ")";
    }

    public String toString() {
        return Utils.r(this.properties());
    }
}

