/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.Position;

public class ParseException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    public static ParseException create(Throwable e) {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException e2 = (InvocationTargetException)e;
            e = e2.getCause();
        }
        if (e instanceof ParseException) {
            ParseException e3 = (ParseException)e;
            return e3;
        }
        return new ParseException(e);
    }

    private static String getMessage(ParserSession session, String msg, Object ... args) {
        if (args.length != 0) {
            msg = Utils.f((String)msg, (Object[])args);
        }
        if (Utils.nn((Object)session)) {
            String lines;
            Position p = session.getPosition();
            StringBuilder sb = new StringBuilder(msg);
            sb.append("\n\tAt: ").append(p);
            JsonMap lastLocation = session.getLastLocation();
            if (Utils.nn((Object)lastLocation)) {
                sb.append("\n\tWhile parsing into: ");
                lastLocation.forEach((k, v) -> sb.append("\n\t\t").append((String)k).append(": ").append(v));
            }
            if ((lines = session.getInputAsString()) == null) {
                sb.append("\n\tUse BEAN_debug setting to display content.");
            } else {
                int numLines = session.getDebugOutputLines();
                int start = p.line - numLines;
                int end = p.line + numLines;
                sb.append("\n---start--\n").append(StringUtils.getNumberedLines((String)lines, (int)start, (int)end)).append("---end---");
            }
            msg = sb.toString();
        }
        return msg;
    }

    public ParseException(ParserSession session, Exception causedBy) {
        super(causedBy, ParseException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    public ParseException(ParserSession session, String message, Object ... args) {
        super(ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Throwable causedBy, String message, Object ... args) {
        super(causedBy, ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(String message, Object ... args) {
        super(message, args);
    }

    public ParseException(Throwable causedBy) {
        super(causedBy);
    }

    public ParseException(Throwable causedBy, String message, Object ... args) {
        super(causedBy, message, args);
    }

    public ParseException getRootCause() {
        ParseException t = this;
        while (t.getCause() != null && t.getCause() instanceof ParseException) {
            t = (ParseException)t.getCause();
        }
        return t;
    }

    @Override
    public ParseException setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }
}

