/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.util.Collection;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class AssertionUtils {
    public static final void assertArg(boolean expression, String msg, Object ... args) throws IllegalArgumentException {
        if (!expression) {
            throw ThrowableUtils.illegalArg(msg, args);
        }
    }

    public static final void assertState(boolean expression, String msg, Object ... args) throws IllegalStateException {
        if (!expression) {
            throw ThrowableUtils.illegalState(msg, args);
        }
    }

    public static final <T> T assertArgNotNull(String name, T o) throws IllegalArgumentException {
        AssertionUtils.assertArg(o != null, "Argument ''{0}'' cannot be null.", name);
        return o;
    }

    public static final <T> T assertNotNull(T o, String msg, Object ... args) throws IllegalStateException {
        if (o == null) {
            throw ThrowableUtils.illegalState(msg, args);
        }
        return o;
    }

    public static final String assertArgNotNullOrBlank(String name, String o) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name, o);
        AssertionUtils.assertArg(!o.isBlank(), "Argument ''{0}'' cannot be blank.", name);
        return o;
    }

    public static final void assertArgsNotNull(String name1, Object o1, String name2, Object o2) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name1, o1);
        AssertionUtils.assertArgNotNull(name2, o2);
    }

    public static final void assertArgsNotNull(String name1, Object o1, String name2, Object o2, String name3, Object o3) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name1, o1);
        AssertionUtils.assertArgNotNull(name2, o2);
        AssertionUtils.assertArgNotNull(name3, o3);
    }

    public static final void assertArgsNotNull(String name1, Object o1, String name2, Object o2, String name3, Object o3, String name4, Object o4) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name1, o1);
        AssertionUtils.assertArgNotNull(name2, o2);
        AssertionUtils.assertArgNotNull(name3, o3);
        AssertionUtils.assertArgNotNull(name4, o4);
    }

    public static final void assertArgsNotNull(String name1, Object o1, String name2, Object o2, String name3, Object o3, String name4, Object o4, String name5, Object o5) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name1, o1);
        AssertionUtils.assertArgNotNull(name2, o2);
        AssertionUtils.assertArgNotNull(name3, o3);
        AssertionUtils.assertArgNotNull(name4, o4);
        AssertionUtils.assertArgNotNull(name5, o5);
    }

    public static final <T> T assertType(Class<T> type, Object o) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("o", o);
        if (!type.isInstance(o)) {
            throw ThrowableUtils.illegalArg("Object is not an instance of {0}: {1}", Utils.cn(type), Utils.cn(o));
        }
        return (T)o;
    }

    public static final <T> T assertType(Class<T> type, Object o, Supplier<? extends RuntimeException> exceptionSupplier) throws RuntimeException {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("o", o);
        if (!type.isInstance(o)) {
            throw exceptionSupplier.get();
        }
        return (T)o;
    }

    public static final <E> Class<E>[] assertClassArrayArgIsType(String name, Class<E> type, Class<?>[] value) throws IllegalArgumentException {
        for (int i = 0; i < value.length; ++i) {
            if (type.isAssignableFrom(value[i])) continue;
            throw ThrowableUtils.illegalArg("Arg {0} did not have arg of type {1} at index {2}: {3}", name, Utils.cn(type), i, Utils.cn(value[i]));
        }
        return value;
    }

    @SafeVarargs
    public static final <T> T assertOneOf(T actual, T ... expected) {
        for (T e : expected) {
            if (!Utils.eq(actual, e)) continue;
            return actual;
        }
        throw new AssertionError((Object)("Invalid value specified: " + String.valueOf(actual)));
    }

    public static final <T> T[] assertArgNoNulls(String name, T[] o) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name, o);
        for (int i = 0; i < o.length; ++i) {
            AssertionUtils.assertArg(Utils.nn(o[i]), "Argument ''{0}'' parameter {1} cannot be null.", name, i);
        }
        return o;
    }

    public static final <T, C extends Collection<T>> C assertArgNoNulls(String name, C collection) throws IllegalArgumentException {
        AssertionUtils.assertArgNotNull(name, collection);
        int i = 0;
        for (T element : collection) {
            AssertionUtils.assertArg(Utils.nn(element), "Argument ''{0}'' element at index {1} cannot be null.", name, i++);
        }
        return collection;
    }
}

