/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.openapi3.Discriminator;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.Items;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Xml;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SchemaInfo
extends OpenApiElement {
    private String format;
    private String title;
    private String description;
    private String pattern;
    private String ref;
    private String type;
    private Number multipleOf;
    private Number maximum;
    private Number minimum;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Boolean nullable;
    private Boolean writeOnly;
    private Boolean readOnly;
    private Boolean deprecated;
    private Object default_;
    private Object example;
    private Items items;
    private Xml xml;
    private ExternalDocumentation externalDocs;
    private List<Object> allOf = CollectionUtils.list((Object[])new Object[0]);
    private List<Object> oneOf = CollectionUtils.list((Object[])new Object[0]);
    private List<Object> anyOf = CollectionUtils.list((Object[])new Object[0]);
    private List<Object> enum_ = CollectionUtils.list((Object[])new Object[0]);
    private List<String> required = CollectionUtils.list((Object[])new String[0]);
    private Discriminator discriminator;
    private Map<String, SchemaInfo> properties;
    private SchemaInfo additionalProperties;
    private SchemaInfo not;

    public SchemaInfo() {
    }

    public SchemaInfo(SchemaInfo copyFrom) {
        super(copyFrom);
        this.format = copyFrom.format;
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.ref = copyFrom.ref;
        this.nullable = copyFrom.nullable;
        this.writeOnly = copyFrom.writeOnly;
        this.deprecated = copyFrom.deprecated;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.discriminator = copyFrom.discriminator;
        this.multipleOf = copyFrom.multipleOf;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.maxProperties = copyFrom.maxProperties;
        this.minProperties = copyFrom.minProperties;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.readOnly = copyFrom.readOnly;
        this.default_ = copyFrom.default_;
        this.example = copyFrom.example;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.xml = copyFrom.xml == null ? null : copyFrom.xml.copy();
        ExternalDocumentation externalDocumentation = this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(copyFrom.enum_);
        }
        if (Utils.nn(copyFrom.allOf)) {
            this.allOf.addAll(copyFrom.allOf);
        }
        if (Utils.nn(copyFrom.required)) {
            this.required.addAll(copyFrom.required);
        }
        if (Utils.nn(copyFrom.anyOf)) {
            this.anyOf.addAll(copyFrom.anyOf);
        }
        if (Utils.nn(copyFrom.oneOf)) {
            this.oneOf.addAll(copyFrom.oneOf);
        }
        this.properties = CollectionUtils.copyOf(copyFrom.properties, SchemaInfo::copy);
        this.additionalProperties = copyFrom.additionalProperties == null ? null : copyFrom.additionalProperties.copy();
        this.not = copyFrom.not == null ? null : copyFrom.not.copy();
    }

    public SchemaInfo addAllOf(Object ... values) {
        if (Utils.nn((Object)values)) {
            for (Object v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.allOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addAnyOf(Object ... values) {
        if (Utils.nn((Object)values)) {
            for (Object v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.anyOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addEnum(Object ... values) {
        if (Utils.nn((Object)values)) {
            for (Object v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addOneOf(Object ... values) {
        if (Utils.nn((Object)values)) {
            for (Object v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.oneOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addRequired(String ... values) {
        if (Utils.nn((Object)values)) {
            for (String v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.required.add(v);
            }
        }
        return this;
    }

    public SchemaInfo copy() {
        return new SchemaInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "format" -> ConverterUtils.toType((Object)this.getFormat(), type);
            case "title" -> ConverterUtils.toType((Object)this.getTitle(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "default" -> ConverterUtils.toType((Object)this.getDefault(), type);
            case "multipleOf" -> ConverterUtils.toType((Object)this.getMultipleOf(), type);
            case "maximum" -> ConverterUtils.toType((Object)this.getMaximum(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType((Object)this.getExclusiveMaximum(), type);
            case "minimum" -> ConverterUtils.toType((Object)this.getMinimum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType((Object)this.getExclusiveMinimum(), type);
            case "maxLength" -> ConverterUtils.toType((Object)this.getMaxLength(), type);
            case "minLength" -> ConverterUtils.toType((Object)this.getMinLength(), type);
            case "pattern" -> ConverterUtils.toType((Object)this.getPattern(), type);
            case "maxItems" -> ConverterUtils.toType((Object)this.getMaxItems(), type);
            case "minItems" -> ConverterUtils.toType((Object)this.getMinItems(), type);
            case "uniqueItems" -> ConverterUtils.toType((Object)this.getUniqueItems(), type);
            case "maxProperties" -> ConverterUtils.toType((Object)this.getMaxProperties(), type);
            case "minProperties" -> ConverterUtils.toType((Object)this.getMinProperties(), type);
            case "required" -> ConverterUtils.toType(this.getRequired(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "type" -> ConverterUtils.toType((Object)this.getType(), type);
            case "items" -> ConverterUtils.toType((Object)this.getItems(), type);
            case "allOf" -> ConverterUtils.toType(this.getAllOf(), type);
            case "oneOf" -> ConverterUtils.toType(this.getOneOf(), type);
            case "anyOf" -> ConverterUtils.toType(this.getAnyOf(), type);
            case "properties" -> ConverterUtils.toType(this.getProperties(), type);
            case "additionalProperties" -> ConverterUtils.toType((Object)this.getAdditionalProperties(), type);
            case "not" -> ConverterUtils.toType((Object)this.getNot(), type);
            case "nullable" -> ConverterUtils.toType((Object)this.getNullable(), type);
            case "deprecated" -> ConverterUtils.toType((Object)this.getDeprecated(), type);
            case "discriminator" -> ConverterUtils.toType((Object)this.getDiscriminator(), type);
            case "readOnly" -> ConverterUtils.toType((Object)this.getReadOnly(), type);
            case "writeOnly" -> ConverterUtils.toType((Object)this.getWriteOnly(), type);
            case "xml" -> ConverterUtils.toType((Object)this.getXml(), type);
            case "externalDocs" -> ConverterUtils.toType((Object)this.getExternalDocs(), type);
            case "example" -> ConverterUtils.toType((Object)this.getExample(), type);
            case "$ref" -> ConverterUtils.toType((Object)this.getRef(), type);
            default -> super.get(property, type);
        });
    }

    public SchemaInfo getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<Object> getAllOf() {
        return Utils.nullIfEmpty(this.allOf);
    }

    public List<Object> getAnyOf() {
        return Utils.nullIfEmpty(this.anyOf);
    }

    public Object getDefault() {
        return this.default_;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public List<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Object getExample() {
        return this.example;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getFormat() {
        return this.format;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public SchemaInfo getNot() {
        return this.not;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public List<Object> getOneOf() {
        return Utils.nullIfEmpty(this.oneOf);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Map<String, SchemaInfo> getProperties() {
        return this.properties;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public List<String> getRequired() {
        return Utils.nullIfEmpty(this.required);
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public Xml getXml() {
        return this.xml;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.ref), (Object)"$ref").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(Utils.ne(this.allOf), (Object)"allOf").addIf(Utils.ne(this.anyOf), (Object)"anyOf").addIf(Utils.nn((Object)this.default_), (Object)"default").addIf(Utils.nn((Object)this.deprecated), (Object)"deprecated").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.discriminator), (Object)"discriminator").addIf(Utils.ne(this.enum_), (Object)"enum").addIf(Utils.nn((Object)this.example), (Object)"example").addIf(Utils.nn((Object)this.exclusiveMaximum), (Object)"exclusiveMaximum").addIf(Utils.nn((Object)this.exclusiveMinimum), (Object)"exclusiveMinimum").addIf(Utils.nn((Object)this.externalDocs), (Object)"externalDocs").addIf(Utils.nn((Object)this.format), (Object)"format").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.not), (Object)"not").addIf(Utils.nn((Object)this.nullable), (Object)"nullable").addIf(Utils.ne(this.oneOf), (Object)"oneOf").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.readOnly), (Object)"readOnly").addIf(Utils.ne(this.required), (Object)"required").addIf(Utils.nn((Object)this.title), (Object)"title").addIf(Utils.nn((Object)this.type), (Object)"type").addIf(Utils.nn((Object)this.uniqueItems), (Object)"uniqueItems").addIf(Utils.nn((Object)this.writeOnly), (Object)"writeOnly").addIf(Utils.nn((Object)this.xml), (Object)"xml").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public SchemaInfo resolveRefs(OpenApi openApi, Deque<String> refStack, int maxDepth) {
        if (Utils.nn((Object)this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            SchemaInfo r = openApi.findRef(this.ref, SchemaInfo.class);
            r = r.resolveRefs(openApi, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (Utils.nn((Object)this.items)) {
            this.items = this.items.resolveRefs(openApi, refStack, maxDepth);
        }
        if (Utils.nn(this.properties)) {
            for (Map.Entry<String, SchemaInfo> e : this.properties.entrySet()) {
                e.setValue(e.getValue().resolveRefs(openApi, refStack, maxDepth));
            }
        }
        if (Utils.nn((Object)this.additionalProperties)) {
            this.additionalProperties = this.additionalProperties.resolveRefs(openApi, refStack, maxDepth);
        }
        this.example = null;
        return this;
    }

    @Override
    public SchemaInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "$ref" -> this.setRef(value);
            case "additionalProperties" -> this.setAdditionalProperties((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "allOf" -> this.setAllOf(CollectionUtils.listb(Object.class).addAny(new Object[]{value}).sparse().build());
            case "anyOf" -> this.setAnyOf(CollectionUtils.listb(Object.class).addAny(new Object[]{value}).sparse().build());
            case "default" -> this.setDefault(value);
            case "deprecated" -> this.setDeprecated(ConverterUtils.toBoolean((Object)value));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "discriminator" -> this.setDiscriminator((Discriminator)ConverterUtils.toType((Object)value, Discriminator.class));
            case "enum" -> this.setEnum(CollectionUtils.listb(Object.class).addAny(new Object[]{value}).sparse().build());
            case "example" -> this.setExample(value);
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean((Object)value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean((Object)value));
            case "externalDocs" -> this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            case "format" -> this.setFormat(Utils.s((Object)value));
            case "items" -> this.setItems((Items)ConverterUtils.toType((Object)value, Items.class));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger((Object)value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger((Object)value));
            case "maxProperties" -> this.setMaxProperties(ConverterUtils.toInteger((Object)value));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber((Object)value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger((Object)value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger((Object)value));
            case "minProperties" -> this.setMinProperties(ConverterUtils.toInteger((Object)value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber((Object)value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber((Object)value));
            case "not" -> this.setNot((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "nullable" -> this.setNullable(ConverterUtils.toBoolean((Object)value));
            case "oneOf" -> this.setOneOf(CollectionUtils.listb(Object.class).addAny(new Object[]{value}).sparse().build());
            case "pattern" -> this.setPattern(Utils.s((Object)value));
            case "properties" -> this.setProperties(ConverterUtils.toMapBuilder((Object)value, String.class, SchemaInfo.class).sparse().build());
            case "readOnly" -> this.setReadOnly(ConverterUtils.toBoolean((Object)value));
            case "required" -> this.setRequired(CollectionUtils.listb(String.class).addAny(new Object[]{value}).sparse().build());
            case "title" -> this.setTitle(Utils.s((Object)value));
            case "type" -> this.setType(Utils.s((Object)value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean((Object)value));
            case "writeOnly" -> this.setWriteOnly(ConverterUtils.toBoolean((Object)value));
            case "xml" -> this.setXml((Xml)ConverterUtils.toType((Object)value, Xml.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SchemaInfo setAdditionalProperties(SchemaInfo value) {
        this.additionalProperties = value;
        return this;
    }

    public SchemaInfo setAllOf(Collection<Object> value) {
        this.allOf.clear();
        if (Utils.nn(value)) {
            this.allOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setAnyOf(Collection<Object> value) {
        this.anyOf.clear();
        if (Utils.nn(value)) {
            this.anyOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public SchemaInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public SchemaInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SchemaInfo setDiscriminator(Discriminator value) {
        this.discriminator = value;
        return this;
    }

    public SchemaInfo setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public SchemaInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public SchemaInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public SchemaInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public SchemaInfo setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public SchemaInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public SchemaInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public SchemaInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public SchemaInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public SchemaInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public SchemaInfo setMaxProperties(Integer value) {
        this.maxProperties = value;
        return this;
    }

    public SchemaInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public SchemaInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public SchemaInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public SchemaInfo setMinProperties(Integer value) {
        this.minProperties = value;
        return this;
    }

    public SchemaInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public SchemaInfo setNot(SchemaInfo value) {
        this.not = value;
        return this;
    }

    public SchemaInfo setNullable(Boolean value) {
        this.nullable = value;
        return this;
    }

    public SchemaInfo setOneOf(Collection<Object> value) {
        this.oneOf.clear();
        if (Utils.nn(value)) {
            this.oneOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public SchemaInfo setProperties(Map<String, SchemaInfo> value) {
        this.properties = CollectionUtils.copyOf(value);
        return this;
    }

    public SchemaInfo setReadOnly(Boolean value) {
        this.readOnly = value;
        return this;
    }

    @Beanp(value="$ref")
    public SchemaInfo setRef(Object value) {
        this.ref = Utils.s((Object)value);
        return this;
    }

    public SchemaInfo setRequired(Collection<String> value) {
        this.required.clear();
        if (Utils.nn(value)) {
            this.required.addAll(value);
        }
        return this;
    }

    public SchemaInfo setTitle(String value) {
        this.title = value;
        return this;
    }

    public SchemaInfo setType(String value) {
        this.type = value;
        return this;
    }

    public SchemaInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public SchemaInfo setWriteOnly(Boolean value) {
        this.writeOnly = value;
        return this;
    }

    public SchemaInfo setXml(Xml value) {
        this.xml = value;
        return this;
    }

    @Override
    public SchemaInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public SchemaInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

