/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.function.Function5;
import org.apache.juneau.commons.function.Tuple5;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.SystemUtils;
import org.apache.juneau.commons.utils.Utils;

public class Cache5<K1, K2, K3, K4, K5, V> {
    private final Map<Tuple5<K1, K2, K3, K4, K5>, V> map;
    private final ThreadLocal<Map<Tuple5<K1, K2, K3, K4, K5>, V>> threadLocalMap;
    private final boolean isThreadLocal;
    private final int maxSize;
    private final CacheMode cacheMode;
    private final Function5<K1, K2, K3, K4, K5, V> supplier;
    private final AtomicInteger cacheHits = new AtomicInteger();

    public static <K1, K2, K3, K4, K5, V> Builder<K1, K2, K3, K4, K5, V> create() {
        return new Builder();
    }

    public static <K1, K2, K3, K4, K5, V> Builder<K1, K2, K3, K4, K5, V> of(Class<K1> key1, Class<K2> key2, Class<K3> key3, Class<K4> key4, Class<K5> key5, Class<V> type) {
        return new Builder();
    }

    protected Cache5(Builder<K1, K2, K3, K4, K5, V> builder) {
        this.maxSize = builder.maxSize;
        this.cacheMode = builder.cacheMode;
        this.supplier = builder.supplier;
        this.isThreadLocal = builder.threadLocal;
        if (this.isThreadLocal) {
            this.threadLocalMap = builder.cacheMode == CacheMode.WEAK ? ThreadLocal.withInitial(() -> Collections.synchronizedMap(new WeakHashMap())) : ThreadLocal.withInitial(() -> new ConcurrentHashMap());
            this.map = null;
        } else {
            this.map = builder.cacheMode == CacheMode.WEAK ? Collections.synchronizedMap(new WeakHashMap()) : new ConcurrentHashMap<Tuple5<K1, K2, K3, K4, K5>, V>();
            this.threadLocalMap = null;
        }
        if (builder.logOnExit) {
            SystemUtils.shutdownMessage(() -> builder.id + ":  hits=" + this.cacheHits.get() + ", misses: " + this.size());
        }
    }

    public void clear() {
        this.getMap().clear();
    }

    public boolean containsKey(K1 key1, K2 key2, K3 key3, K4 key4, K5 key5) {
        return this.getMap().containsKey(Tuple5.of(key1, key2, key3, key4, key5));
    }

    public boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        return this.getMap().containsValue(value);
    }

    public V get(K1 key1, K2 key2, K3 key3, K4 key4, K5 key5) {
        return (V)this.get(key1, key2, key3, key4, key5, () -> this.supplier.apply(key1, key2, key3, key4, key5));
    }

    public V get(K1 key1, K2 key2, K3 key3, K4 key4, K5 key5, Supplier<V> supplier) {
        Tuple5<K1, K2, K3, K4, K5> wrapped;
        AssertionUtils.assertArgNotNull("supplier", supplier);
        if (this.cacheMode == CacheMode.NONE) {
            return supplier.get();
        }
        Map<Tuple5<K1, K2, K3, K4, K5>, V> m = this.getMap();
        V v = m.get(wrapped = Tuple5.of(key1, key2, key3, key4, key5));
        if (v == null) {
            if (this.size() > this.maxSize) {
                this.clear();
            }
            if ((v = supplier.get()) == null) {
                m.remove(wrapped);
            } else {
                m.putIfAbsent(wrapped, v);
            }
        } else {
            this.cacheHits.incrementAndGet();
        }
        return v;
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public V put(K1 key1, K2 key2, K3 key3, K4 key4, K5 key5, V value) {
        Map<Tuple5<K1, K2, K3, K4, K5>, V> m = this.getMap();
        if (value == null) {
            return m.remove(Tuple5.of(key1, key2, key3, key4, key5));
        }
        return m.put(Tuple5.of(key1, key2, key3, key4, key5), value);
    }

    public V remove(K1 key1, K2 key2, K3 key3, K4 key4, K5 key5) {
        return this.getMap().remove(Tuple5.of(key1, key2, key3, key4, key5));
    }

    public int size() {
        return this.getMap().size();
    }

    private Map<Tuple5<K1, K2, K3, K4, K5>, V> getMap() {
        return this.isThreadLocal ? this.threadLocalMap.get() : this.map;
    }

    public static class Builder<K1, K2, K3, K4, K5, V> {
        CacheMode cacheMode = Utils.env("juneau.cache.mode", CacheMode.FULL);
        int maxSize = Utils.env("juneau.cache.maxSize", 1000);
        String id = "Cache5";
        boolean logOnExit = Utils.env("juneau.cache.logOnExit", false);
        boolean threadLocal;
        Function5<K1, K2, K3, K4, K5, V> supplier;

        Builder() {
        }

        public Cache5<K1, K2, K3, K4, K5, V> build() {
            return new Cache5(this);
        }

        public Builder<K1, K2, K3, K4, K5, V> cacheMode(CacheMode value) {
            this.cacheMode = value;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> logOnExit(boolean value, String idValue) {
            this.id = idValue;
            this.logOnExit = value;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> logOnExit(String value) {
            this.id = value;
            this.logOnExit = true;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> maxSize(int value) {
            this.maxSize = value;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> supplier(Function5<K1, K2, K3, K4, K5, V> value) {
            this.supplier = value;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> threadLocal() {
            this.threadLocal = true;
            return this;
        }

        public Builder<K1, K2, K3, K4, K5, V> weak() {
            return this.cacheMode(CacheMode.WEAK);
        }
    }
}

