/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.SearchNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalDeleteDataNode
extends AbstractDeleteDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalDeleteDataNode.class);
    private static final int FIXED_SERIALIZED_SIZE = 2;
    private final List<TableDeletionEntry> modEntries;
    private Collection<TRegionReplicaSet> replicaSets;
    private final String databaseName;

    public RelationalDeleteDataNode(PlanNodeId id, Delete delete) {
        super(id);
        this.modEntries = delete.getTableDeletionEntries();
        this.replicaSets = delete.getReplicaSets();
        this.databaseName = delete.getDatabaseName();
    }

    public RelationalDeleteDataNode(PlanNodeId id, TableDeletionEntry entry, String databaseName) {
        super(id);
        this.modEntries = Collections.singletonList(entry);
        this.databaseName = databaseName;
    }

    public RelationalDeleteDataNode(PlanNodeId id, List<TableDeletionEntry> entries, String databaseName) {
        super(id);
        this.modEntries = entries;
        this.databaseName = databaseName;
    }

    public RelationalDeleteDataNode(PlanNodeId id, Delete delete, ProgressIndex progressIndex) {
        this(id, delete);
        this.progressIndex = progressIndex;
    }

    public RelationalDeleteDataNode(PlanNodeId id, Delete delete, TRegionReplicaSet regionReplicaSet) {
        this(id, delete);
        this.regionReplicaSet = regionReplicaSet;
    }

    public RelationalDeleteDataNode(PlanNodeId id, TableDeletionEntry delete, TRegionReplicaSet regionReplicaSet, String databaseName) {
        this(id, delete, databaseName);
        this.regionReplicaSet = regionReplicaSet;
    }

    public RelationalDeleteDataNode(PlanNodeId id, List<TableDeletionEntry> deletes, TRegionReplicaSet regionReplicaSet, String databaseName) {
        this(id, deletes, databaseName);
        this.regionReplicaSet = regionReplicaSet;
    }

    public static RelationalDeleteDataNode deserializeFromWAL(DataInputStream stream) throws IOException {
        long searchIndex = stream.readLong();
        int entryNum = ReadWriteForEncodingUtils.readVarInt((InputStream)stream);
        ArrayList<TableDeletionEntry> modEntries = new ArrayList<TableDeletionEntry>(entryNum);
        for (int i = 0; i < entryNum; ++i) {
            modEntries.add((TableDeletionEntry)ModEntry.createFrom(stream));
        }
        String databaseName = ReadWriteIOUtils.readVarIntString((InputStream)stream);
        RelationalDeleteDataNode deleteDataNode = new RelationalDeleteDataNode(new PlanNodeId(""), modEntries, databaseName);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    public static RelationalDeleteDataNode deserializeFromWAL(ByteBuffer buffer) {
        long searchIndex = buffer.getLong();
        int entryNum = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)buffer);
        ArrayList<TableDeletionEntry> modEntries = new ArrayList<TableDeletionEntry>(entryNum);
        for (int i = 0; i < entryNum; ++i) {
            modEntries.add((TableDeletionEntry)ModEntry.createFrom(buffer));
        }
        String databaseName = ReadWriteIOUtils.readVarIntString((ByteBuffer)buffer);
        RelationalDeleteDataNode deleteDataNode = new RelationalDeleteDataNode(new PlanNodeId(""), modEntries, databaseName);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    public static RelationalDeleteDataNode deserialize(ByteBuffer byteBuffer) {
        int entryNum = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)byteBuffer);
        ArrayList<TableDeletionEntry> modEntries = new ArrayList<TableDeletionEntry>(entryNum);
        for (int i = 0; i < entryNum; ++i) {
            modEntries.add((TableDeletionEntry)ModEntry.createFrom(byteBuffer));
        }
        String databaseName = ReadWriteIOUtils.readVarIntString((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        int ignoredChildrenSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        RelationalDeleteDataNode relationalDeleteDataNode = new RelationalDeleteDataNode(planNodeId, modEntries, databaseName);
        return relationalDeleteDataNode;
    }

    public static RelationalDeleteDataNode deserializeFromDAL(ByteBuffer byteBuffer) {
        short nodeType = byteBuffer.getShort();
        int entryNum = ReadWriteForEncodingUtils.readVarInt((ByteBuffer)byteBuffer);
        ArrayList<TableDeletionEntry> modEntries = new ArrayList<TableDeletionEntry>(entryNum);
        for (int i = 0; i < entryNum; ++i) {
            modEntries.add((TableDeletionEntry)ModEntry.createFrom(byteBuffer));
        }
        String databaseName = ReadWriteIOUtils.readVarIntString((ByteBuffer)byteBuffer);
        ProgressIndex deserializedIndex = ProgressIndexType.deserializeFrom((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        int ignoredChildrenSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        RelationalDeleteDataNode relationalDeleteDataNode = new RelationalDeleteDataNode(planNodeId, modEntries, databaseName);
        relationalDeleteDataNode.setProgressIndex(deserializedIndex);
        return relationalDeleteDataNode;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer serializeToDAL() {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                DeleteNodeType.RELATIONAL_DELETE_NODE.serialize(outputStream);
                this.serializeAttributes(outputStream);
                this.progressIndex.serialize((OutputStream)outputStream);
                this.id.serialize(outputStream);
                ReadWriteIOUtils.write((int)0, (OutputStream)outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new SerializationRunTimeException((Throwable)e);
        }
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.RELATIONAL_DELETE_DATA;
    }

    @Override
    public PlanNode clone() {
        return new RelationalDeleteDataNode(this.getPlanNodeId(), this.modEntries, this.databaseName);
    }

    @Override
    public int serializedSize() {
        int size = 2 + ReadWriteForEncodingUtils.varIntSize((int)this.modEntries.size());
        for (TableDeletionEntry modEntry : this.modEntries) {
            size += modEntry.serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putShort(PlanNodeType.RELATIONAL_DELETE_DATA.getNodeType());
        buffer.putLong(this.searchIndex);
        try {
            ReadWriteForEncodingUtils.writeVarInt((int)this.modEntries.size(), (OutputStream)buffer);
            for (TableDeletionEntry modEntry : this.modEntries) {
                modEntry.serialize(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to serialize modEntry to WAL", (Throwable)e);
        }
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.RELATIONAL_DELETE_DATA.serialize(byteBuffer);
        ReadWriteForEncodingUtils.writeVarInt((int)this.modEntries.size(), (ByteBuffer)byteBuffer);
        this.modEntries.forEach(entry -> entry.serialize(byteBuffer));
        ReadWriteIOUtils.writeVar((String)this.databaseName, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.RELATIONAL_DELETE_DATA.serialize(stream);
        ReadWriteForEncodingUtils.writeVarInt((int)this.modEntries.size(), (OutputStream)stream);
        for (TableDeletionEntry modEntry : this.modEntries) {
            modEntry.serialize(stream);
        }
        ReadWriteIOUtils.writeVar((String)this.databaseName, (OutputStream)stream);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteData(this, context);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationalDeleteDataNode that = (RelationalDeleteDataNode)obj;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.modEntries, that.modEntries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.modEntries, this.progressIndex);
    }

    public String toString() {
        return String.format("RelationalDeleteDataNode-%s[ Deletion: %s, Region: %s, ProgressIndex: %s, SearchIndex: %d]", this.getPlanNodeId(), this.modEntries, this.regionReplicaSet == null ? "Not Assigned" : this.regionReplicaSet.getRegionId(), this.progressIndex == null ? "Not Assigned" : this.progressIndex, this.searchIndex);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        return this.replicaSets.stream().map(r -> new RelationalDeleteDataNode(this.getPlanNodeId(), this.modEntries, (TRegionReplicaSet)r, this.databaseName)).collect(Collectors.toList());
    }

    public List<TableDeletionEntry> getModEntries() {
        return this.modEntries;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public SearchNode merge(List<SearchNode> searchNodes) {
        List relationalDeleteDataNodeList = searchNodes.stream().map(searchNode -> (RelationalDeleteDataNode)searchNode).collect(Collectors.toList());
        if (relationalDeleteDataNodeList.stream().anyMatch(relationalDeleteDataNode -> this.getDatabaseName() != null && !this.getDatabaseName().equals(relationalDeleteDataNode.getDatabaseName()))) {
            throw new IllegalArgumentException("All database name need to be same");
        }
        List<TableDeletionEntry> allTableDeletionEntries = relationalDeleteDataNodeList.stream().map(RelationalDeleteDataNode::getModEntries).flatMap(Collection::stream).collect(Collectors.toList());
        return new RelationalDeleteDataNode(this.getPlanNodeId(), allTableDeletionEntries, this.databaseName).setSearchIndex(this.getSearchIndex());
    }
}

