/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class DeleteDeviceTask
implements IConfigTask {
    private final DeleteDevice deleteDevice;
    private final String queryId;
    private final SessionInfo sessionInfo;

    public DeleteDeviceTask(DeleteDevice deleteDevice, String queryId, SessionInfo sessionInfo) {
        this.deleteDevice = deleteDevice;
        this.queryId = queryId;
        this.sessionInfo = sessionInfo;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.deleteDevice(this.deleteDevice, this.queryId, this.sessionInfo);
    }

    public static void buildTSBlock(long deviceNum, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.TEXT));
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(deviceNum >= 0L ? String.valueOf(deviceNum) : "UNKNOWN", TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), new DatasetHeader(Collections.singletonList(new ColumnHeader("num_of_deleted_devices", TSDataType.TEXT)), true)));
    }
}

