/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class DataNodeDevicePathCache {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private final IMemoryBlock devicePathCacheMemoryBlock = memoryConfig.getDevicePathCacheMemoryManager().exactAllocate("DevicePathCache", MemoryBlockType.STATIC);
    private final Cache<String, PartialPath> devicePathCache;

    private DataNodeDevicePathCache() {
        this.devicePathCacheMemoryBlock.allocate(this.devicePathCacheMemoryBlock.getTotalMemorySizeInBytes());
        this.devicePathCache = Caffeine.newBuilder().maximumWeight(this.devicePathCacheMemoryBlock.getTotalMemorySizeInBytes()).weigher((key, val) -> PartialPath.estimateSize((PartialPath)val) + 32).build();
    }

    public static DataNodeDevicePathCache getInstance() {
        return DataNodeDevicePathCacheHolder.INSTANCE;
    }

    public PartialPath getPartialPath(String deviceId) throws IllegalPathException {
        try {
            return (PartialPath)this.devicePathCache.get((Object)deviceId, path -> {
                try {
                    return new PartialPath(path);
                }
                catch (IllegalPathException e) {
                    try {
                        return PartialPath.getQualifiedDatabasePartialPath((String)path);
                    }
                    catch (IllegalPathException e1) {
                        throw new IllegalArgumentException(e1);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPathException(deviceId);
        }
    }

    public String getDeviceId(String deviceId) {
        try {
            return this.getPartialPath(deviceId).getFullPath();
        }
        catch (IllegalPathException e) {
            return deviceId;
        }
    }

    public void cleanUp() {
        this.devicePathCache.cleanUp();
    }

    private static class DataNodeDevicePathCacheHolder {
        private static final DataNodeDevicePathCache INSTANCE = new DataNodeDevicePathCache();

        private DataNodeDevicePathCacheHolder() {
        }
    }
}

