/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.UDFTable;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.function.GetFunctionTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.function.GetUDFJarPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.UpdateFunctionPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.function.FunctionTableResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFInfo.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final UDFTable udfTable;
    private final Map<String, String> existedJarToMD5;
    private final UDFExecutableManager udfExecutableManager;
    private final ReentrantLock udfTableLock = new ReentrantLock();
    private static final String SNAPSHOT_FILENAME = "udf_info.bin";

    public UDFInfo() throws IOException {
        this.udfTable = new UDFTable();
        this.existedJarToMD5 = new HashMap<String, String>();
        this.udfExecutableManager = UDFExecutableManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getUdfTemporaryLibDir(), (String)CONFIG_NODE_CONF.getUdfDir());
    }

    public void acquireUDFTableLock() {
        LOGGER.info("acquire UDFTableLock");
        this.udfTableLock.lock();
    }

    public void releaseUDFTableLock() {
        LOGGER.info("release UDFTableLock");
        this.udfTableLock.unlock();
    }

    public void validate(Model model, String udfName, String jarName, String jarMD5) throws UDFManagementException {
        if (this.udfTable.containsUDF(model, udfName) && this.udfTable.getUDFInformation(model, udfName).isAvailable()) {
            throw new UDFManagementException(String.format("Failed to create UDF [%s], the same name UDF has been created", udfName));
        }
        if (this.existedJarToMD5.containsKey(jarName) && !this.existedJarToMD5.get(jarName).equals(jarMD5)) {
            throw new UDFManagementException(String.format("Failed to create UDF [%s], the same name Jar [%s] but different MD5 [%s] has existed", udfName, jarName, jarMD5));
        }
    }

    public UDFInformation getUDFInformation(Model model, String udfName) throws UDFManagementException {
        if (this.udfTable.containsUDF(model, udfName)) {
            return this.udfTable.getUDFInformation(model, udfName);
        }
        throw new UDFManagementException(String.format("Failed to drop UDF [%s], this UDF has not been created", udfName));
    }

    public boolean needToSaveJar(String jarName) {
        return !this.existedJarToMD5.containsKey(jarName);
    }

    public TSStatus addUDFInTable(CreateFunctionPlan physicalPlan) {
        try {
            UDFInformation udfInformation = physicalPlan.getUdfInformation();
            this.udfTable.addUDFInformation(udfInformation.getFunctionName(), udfInformation);
            if (udfInformation.isUsingURI()) {
                this.existedJarToMD5.put(udfInformation.getJarName(), udfInformation.getJarMD5());
                if (physicalPlan.getJarFile() != null) {
                    this.udfExecutableManager.saveToInstallDir(ByteBuffer.wrap(physicalPlan.getJarFile().getValues()), udfInformation.getJarName());
                }
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to add UDF [%s] in UDF_Table on Config Nodes, because of %s", physicalPlan.getUdfInformation().getFunctionName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public DataSet getUDFTable(GetFunctionTablePlan plan) {
        return new FunctionTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.udfTable.getUDFInformationList(plan.getModel()));
    }

    public DataSet getAllUDFTable() {
        return new FunctionTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.udfTable.getAllInformationList());
    }

    public JarResp getUDFJar(GetUDFJarPlan physicalPlan) {
        ArrayList<ByteBuffer> jarList = new ArrayList<ByteBuffer>();
        try {
            for (String jarName : physicalPlan.getJarNames()) {
                jarList.add(ExecutableManager.transferToBytebuffer((String)UDFExecutableManager.getInstance().getFileStringUnderInstallByName(jarName)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Get UDF_Jar failed", (Throwable)e);
            return new JarResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage("Get UDF_Jar failed, because " + e.getMessage()), Collections.emptyList());
        }
        return new JarResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), jarList);
    }

    public TSStatus dropFunction(Model model, String functionName) {
        if (this.udfTable.containsUDF(model, functionName)) {
            this.existedJarToMD5.remove(this.udfTable.getUDFInformation(model, functionName).getJarName());
            this.udfTable.removeUDFInformation(model, functionName);
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus updateFunction(UpdateFunctionPlan req) {
        UDFInformation udfInformation = req.getUdfInformation();
        this.udfTable.addUDFInformation(udfInformation.getFunctionName(), udfInformation);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @TestOnly
    public Map<Model, Map<String, UDFInformation>> getRawUDFTable() {
        return this.udfTable.getTable();
    }

    @TestOnly
    public Map<String, String> getRawExistedJarToMD5() {
        return this.existedJarToMD5;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
            this.serializeExistedJarToMD5(fileOutputStream);
            this.udfTable.serializeUDFTable((OutputStream)fileOutputStream);
            fileOutputStream.getFD().sync();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.acquireUDFTableLock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.clear();
            this.deserializeExistedJarToMD5(fileInputStream);
            this.udfTable.deserializeUDFTable((InputStream)fileInputStream);
        }
        finally {
            this.releaseUDFTableLock();
        }
    }

    public void serializeExistedJarToMD5(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.existedJarToMD5.size(), (OutputStream)outputStream);
        for (Map.Entry<String, String> entry : this.existedJarToMD5.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
        }
    }

    public void deserializeExistedJarToMD5(InputStream inputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            this.existedJarToMD5.put(ReadWriteIOUtils.readString((InputStream)inputStream), ReadWriteIOUtils.readString((InputStream)inputStream));
        }
    }

    public void clear() {
        this.existedJarToMD5.clear();
        this.udfTable.clear();
    }
}

