/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum HistoryUpdateType implements UaEnumeration
{
    Insert(1),
    Replace(2),
    Update(3),
    Delete(4);

    private final int value;

    private HistoryUpdateType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static HistoryUpdateType from(int value) {
        switch (value) {
            case 1: {
                return Insert;
            }
            case 2: {
                return Replace;
            }
            case 3: {
                return Update;
            }
            case 4: {
                return Delete;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11234");
    }

    public static class Codec
    extends GenericDataTypeCodec<HistoryUpdateType> {
        @Override
        public Class<HistoryUpdateType> getType() {
            return HistoryUpdateType.class;
        }

        @Override
        public HistoryUpdateType decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, HistoryUpdateType.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryUpdateType value) {
            encoder.writeEnum(null, value);
        }
    }
}

