/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.auth.AuthorReadPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionManager.class);
    private final ConfigManager configManager;
    private final AuthorInfo authorInfo;

    public PermissionManager(ConfigManager configManager, AuthorInfo authorInfo) {
        this.configManager = configManager;
        this.authorInfo = authorInfo;
    }

    public TSStatus operatePermission(AuthorPlan authorPlan, boolean isGeneratedByPipe) {
        LOGGER.info("Auth: run auth plan: {}", (Object)authorPlan.toString());
        try {
            TSStatus tsStatus;
            if (authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateUser || authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateRole || authorPlan.getAuthorType() == ConfigPhysicalPlanType.CreateUserWithRawPassword) {
                tsStatus = this.getConsensusManager().write(authorPlan);
            } else {
                List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
                tsStatus = this.configManager.getProcedureManager().operateAuthPlan(authorPlan, allDataNodes, isGeneratedByPipe);
            }
            return tsStatus;
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public PermissionInfoResp queryPermission(AuthorReadPlan authorPlan) {
        try {
            return (PermissionInfoResp)this.getConsensusManager().read(authorPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new PermissionInfoResp(res);
        }
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TPermissionInfoResp login(String username, String password) {
        return this.authorInfo.login(username, password);
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<PartialPath> paths, int permission) {
        return this.authorInfo.checkUserPrivileges(username, paths, permission);
    }

    public TAuthizedPatternTreeResp fetchAuthizedPTree(String username, int permission) throws AuthException {
        return this.authorInfo.generateAuthizedPTree(username, permission);
    }

    public TPermissionInfoResp checkUserPrivilegeGrantOpt(String username, List<PartialPath> paths, int permission) throws AuthException {
        return this.authorInfo.checkUserPrivilegeGrantOpt(username, paths, permission);
    }

    public TPermissionInfoResp checkRoleOfUser(String username, String rolename) throws AuthException {
        return this.authorInfo.checkRoleOfUser(username, rolename);
    }

    public void checkUserPathPrivilege() {
        this.authorInfo.checkUserPathPrivilege();
    }
}

