/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.impl.wrappers.ContextualCallable;
import java.util.concurrent.Callable;

public class ContextualCallableN<T>
implements ContextualCallable<T> {
    private ThreadLocal<Object>[] tl;
    private Object[] state;
    private final Callable<T> callable;

    public ContextualCallableN(Callable<T> callable, int n) {
        this.callable = callable;
        this.tl = new ThreadLocal[n];
        this.state = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        Object[] moved = new Object[this.tl.length];
        for (int i = 0; i < this.tl.length; ++i) {
            moved[i] = this.tl[i].get();
            this.tl[i].set(this.state[i]);
        }
        try {
            T t = this.callable.call();
            return t;
        }
        finally {
            for (int i = 0; i < this.tl.length; ++i) {
                this.tl[i].set(moved[i]);
            }
        }
    }

    @Override
    public void captureThreadLocal(int index, ThreadLocal<Object> threadLocal, Object value) {
        if (index < 0 || index >= this.state.length) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        this.tl[index] = threadLocal;
        this.state[index] = value;
    }
}

