/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.apiimpl;

import io.smallrye.faulttolerance.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.apiimpl.CallableInvoker;
import io.smallrye.faulttolerance.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.StrategyInvoker;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedResultDecision;
import io.smallrye.faulttolerance.core.util.ResultDecision;
import io.smallrye.faulttolerance.core.util.SetBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class GuardCommon {
    private static final Class<?>[] NO_PARAMS = new Class[0];

    GuardCommon() {
    }

    static <V, T> AsyncSupport<V, T> asyncSupport(Type type) {
        if (type instanceof Class) {
            return AsyncSupportRegistry.get((Class[])NO_PARAMS, (Class)((Class)type));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            return AsyncSupportRegistry.get((Class[])NO_PARAMS, (Class)rawType);
        }
        return null;
    }

    static <V, T> AsyncInvocation<V, T> asyncInvocation(Callable<T> action, AsyncSupport<V, T> asyncSupport) {
        return asyncSupport != null ? new AsyncInvocation<V, T>(asyncSupport, new CallableInvoker<T>(action), null) : null;
    }

    static <V, T> T guard(Callable<T> action, FaultToleranceStrategy<V> strategy, AsyncInvocation<V, T> asyncInvocation, EventHandlers eventHandlers, Consumer<FaultToleranceContext<?>> contextModifier) throws Exception {
        if (asyncInvocation == null) {
            FaultToleranceContext ctx = new FaultToleranceContext(() -> Future.from((Callable)action), false);
            if (contextModifier != null) {
                contextModifier.accept(ctx);
            }
            eventHandlers.register(ctx);
            try {
                FaultToleranceStrategy<V> castStrategy = strategy;
                return (T)castStrategy.apply(ctx).awaitBlocking();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw SneakyThrow.sneakyThrow((Throwable)e);
            }
        }
        AsyncSupport asyncSupport = asyncInvocation.asyncSupport;
        Invoker toFutureInvoker = asyncInvocation.toFutureInvoker;
        FaultToleranceContext ctx = new FaultToleranceContext(() -> asyncSupport.toFuture(toFutureInvoker), true);
        if (contextModifier != null) {
            contextModifier.accept(ctx);
        }
        eventHandlers.register(ctx);
        StrategyInvoker fromFutureInvoker = new StrategyInvoker(asyncInvocation.arguments, strategy, ctx);
        return (T)asyncSupport.fromFuture((Invoker)fromFutureInvoker);
    }

    static ResultDecision createResultDecision(Predicate<Object> whenResultPredicate) {
        if (whenResultPredicate != null) {
            return new PredicateBasedResultDecision(whenResultPredicate.negate());
        }
        return ResultDecision.ALWAYS_EXPECTED;
    }

    static ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure, Predicate<Throwable> whenExceptionPredicate) {
        if (whenExceptionPredicate != null) {
            return new PredicateBasedExceptionDecision(whenExceptionPredicate.negate());
        }
        return new SetBasedExceptionDecision(GuardCommon.createSetOfThrowables(consideredFailure), GuardCommon.createSetOfThrowables(consideredExpected), true);
    }

    private static SetOfThrowables createSetOfThrowables(Class<? extends Throwable>[] throwableClasses) {
        if (throwableClasses == null || throwableClasses.length == 0) {
            return SetOfThrowables.EMPTY;
        }
        return SetOfThrowables.create((Class[])throwableClasses);
    }
}

