/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.common;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class Uid
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7808395904206530189L;
    private static final int MAX_SEQ_VALUE = 0x40000000;
    protected volatile long[] hostAddr;
    protected volatile int process;
    protected volatile int sec;
    protected volatile int other;
    private volatile int _hashValue;
    private volatile boolean _valid;
    private volatile String _stringForm;
    private volatile byte[] _byteForm;
    private static final AtomicInteger uidsCreated = new AtomicInteger();
    private static volatile int initTime;
    private static final VarHandle BE_LONG_ARRAY_VIEW;
    private static final VarHandle BE_INT_ARRAY_VIEW;
    private static final AtomicReferenceFieldUpdater<Uid, byte[]> BYTE_FORM_UPDATER;
    private static final byte breakChar = 58;
    private static final byte fileBreakChar = 95;
    private static final Uid NIL_UID;
    private static final Uid LAST_RESOURCE_UID;
    private static final Uid MAX_UID;
    private static final Uid MIN_UID;
    public static final int UID_SIZE = 28;

    public Uid() {
        this.hostAddr = null;
        this.process = 0;
        this.sec = 0;
        this.other = 0;
        this._hashValue = -1;
        this._valid = false;
        this._stringForm = null;
        this._byteForm = null;
        try {
            this.hostAddr = Utility.hostInetAddr();
            this.process = Utility.getpid();
            if (initTime == 0) {
                initTime = (int)(System.currentTimeMillis() / 1000L);
            }
            this.sec = initTime;
            this.other = Uid.getValue();
            this._valid = true;
            this.generateHash();
        }
        catch (UnknownHostException e) {
            tsLogger.i18NLogger.warn_common_Uid_1();
            this._valid = false;
        }
    }

    public Uid(Uid copyFrom) {
        this.copy(copyFrom);
    }

    public Uid(byte[] byteForm) {
        if (byteForm == null) {
            throw new IllegalArgumentException();
        }
        this.hostAddr = new long[2];
        this._hashValue = -1;
        this._stringForm = null;
        this._byteForm = null;
        try {
            if (byteForm.length < 28) {
                throw new IllegalArgumentException("byteForm too small: " + byteForm.length);
            }
            long hostAddr0 = BE_LONG_ARRAY_VIEW.get(byteForm, 0);
            long hostAddr1 = BE_LONG_ARRAY_VIEW.get(byteForm, 8);
            int process = BE_INT_ARRAY_VIEW.get(byteForm, 16);
            int sec = BE_INT_ARRAY_VIEW.get(byteForm, 20);
            int other = BE_INT_ARRAY_VIEW.get(byteForm, 24);
            long[] hostAddr = this.hostAddr;
            hostAddr[0] = hostAddr0;
            hostAddr[1] = hostAddr1;
            this.process = process;
            this.sec = sec;
            this.other = other;
            this._valid = true;
        }
        catch (Throwable ex) {
            tsLogger.i18NLogger.warn_common_Uid_bytes(ex);
            this._valid = false;
        }
        this.generateHash();
    }

    public Uid(String uidString) {
        this(uidString, true);
    }

    public Uid(String uidString, boolean errsOk) {
        if (uidString == null) {
            throw new IllegalArgumentException();
        }
        char theBreakChar = Uid.getBreakChar(uidString);
        this.hostAddr = new long[2];
        this.process = 0;
        this.sec = 0;
        this.other = 0;
        this._hashValue = -1;
        this._valid = false;
        this._stringForm = null;
        this._byteForm = null;
        if (uidString.length() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            String s = null;
            try {
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.hostAddr[0] = Utility.hexStringToLong(s);
                startIndex = endIndex + 1;
                ++endIndex;
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.hostAddr[1] = Utility.hexStringToLong(s);
                startIndex = endIndex + 1;
                ++endIndex;
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.process = (int)Utility.hexStringToLong(s);
                startIndex = endIndex + 1;
                ++endIndex;
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.sec = (int)Utility.hexStringToLong(s);
                s = uidString.substring(endIndex + 1, uidString.length());
                this.other = (int)Utility.hexStringToLong(s);
                this._valid = true;
                this.generateHash();
            }
            catch (NumberFormatException e) {
                if (!errsOk) {
                    tsLogger.i18NLogger.warn_common_Uid_3(uidString, e);
                }
                this._valid = false;
            }
            catch (StringIndexOutOfBoundsException e) {
                if (!errsOk) {
                    tsLogger.i18NLogger.warn_common_Uid_3(uidString, e);
                }
                this._valid = false;
            }
            catch (Throwable ex) {
                tsLogger.i18NLogger.warn_common_Uid_npe(uidString, ex);
                this._valid = false;
            }
        } else {
            this.copy(Uid.nullUid());
        }
        if (!this._valid) {
            if (errsOk) {
                try {
                    this.copy(Uid.nullUid());
                    this._valid = false;
                }
                catch (Exception e) {
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        tsLogger.i18NLogger.fatal_common_Uid_4(uidString);
                    }
                    throw new FatalError(tsLogger.i18NLogger.get_common_Uid_2(), e);
                }
            } else {
                throw new FatalError(tsLogger.i18NLogger.get_common_Uid_5(uidString));
            }
        }
    }

    public Uid(long[] addr, int processId, int time, int incr) {
        try {
            this.hostAddr = new long[2];
            this.hostAddr[0] = addr[0];
            this.hostAddr[1] = addr[1];
            this.process = processId;
            this.sec = time;
            this.other = incr;
            this._valid = true;
            this.generateHash();
        }
        catch (Throwable ex) {
            this._valid = false;
            throw new FatalError(tsLogger.i18NLogger.get_common_Uid_11() + String.valueOf(ex));
        }
    }

    public int hashCode() {
        return this._hashValue;
    }

    public void print(PrintStream strm) {
        strm.print("<Uid:" + this.toString() + ">");
    }

    public String stringForm() {
        if (this._stringForm == null) {
            this._stringForm = this.stringForm((byte)58);
        }
        return this._stringForm;
    }

    public String stringForm(byte breakChar) {
        long[] hostAddr = this.hostAddr;
        long hostAddr0 = hostAddr[0];
        long hostAddr1 = hostAddr[1];
        int process = this.process;
        int sec = this.sec;
        int other = this.other;
        int hostAddr0Chars = Utility.hexCharsOf(hostAddr0);
        int hostAddr1Chars = Utility.hexCharsOf(hostAddr1);
        int processChars = Utility.hexCharsOf(process);
        int secChars = Utility.hexCharsOf(sec);
        int otherChars = Utility.hexCharsOf(other);
        int totalChars = hostAddr0Chars + hostAddr1Chars + processChars + secChars + otherChars + 4;
        byte[] asciiBytes = new byte[totalChars];
        int pos = 0;
        Utility.toHexChars(hostAddr0, asciiBytes, pos, hostAddr0Chars);
        pos += hostAddr0Chars;
        asciiBytes[pos++] = breakChar;
        Utility.toHexChars(hostAddr1, asciiBytes, pos, hostAddr1Chars);
        pos += hostAddr1Chars;
        asciiBytes[pos++] = breakChar;
        Utility.toHexChars(process, asciiBytes, pos, processChars);
        pos += processChars;
        asciiBytes[pos++] = breakChar;
        Utility.toHexChars(sec, asciiBytes, pos, secChars);
        pos += secChars;
        asciiBytes[pos++] = breakChar;
        Utility.toHexChars(other, asciiBytes, pos, otherChars);
        return new String(asciiBytes, 0, 0, totalChars);
    }

    public String fileStringForm() {
        return this.stringForm((byte)95);
    }

    public byte[] getBytes() {
        if (this._byteForm == null) {
            long[] hostAddr = this.hostAddr;
            int process = this.process;
            int sec = this.sec;
            int other = this.other;
            try {
                long hostAddr0 = hostAddr[0];
                long hostAddr1 = hostAddr[1];
                byte[] newByteForm = new byte[28];
                BE_LONG_ARRAY_VIEW.set(newByteForm, 0, hostAddr0);
                BE_LONG_ARRAY_VIEW.set(newByteForm, 8, hostAddr1);
                BE_INT_ARRAY_VIEW.set(newByteForm, 16, process);
                BE_INT_ARRAY_VIEW.set(newByteForm, 20, sec);
                BE_INT_ARRAY_VIEW.set(newByteForm, 24, other);
                BYTE_FORM_UPDATER.lazySet(this, newByteForm);
            }
            catch (Throwable ex) {
                tsLogger.i18NLogger.warn_common_Uid_getbytes(ex);
                this._byteForm = null;
            }
        }
        return this._byteForm;
    }

    public String toString() {
        return this.stringForm();
    }

    public String getHexPid() {
        return Utility.intToHexString(this.process);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Uid(this);
    }

    private void copy(Uid toCopy) {
        if (toCopy == this) {
            return;
        }
        this.hostAddr = toCopy.hostAddr;
        this.process = toCopy.process;
        this.sec = toCopy.sec;
        this.other = toCopy.other;
        this._hashValue = toCopy._hashValue;
        this._valid = toCopy._valid;
    }

    public boolean equals(Object o) {
        if (o instanceof Uid) {
            return this.equals((Uid)o);
        }
        return false;
    }

    public boolean equals(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return true;
        }
        return this.other == u.other && this.sec == u.sec && this.process == u.process && this.hostAddr[0] == u.hostAddr[0] && this.hostAddr[1] == u.hostAddr[1];
    }

    public boolean notEquals(Uid u) {
        if (u == null) {
            return true;
        }
        if (u == this) {
            return false;
        }
        return this.other != u.other || this.sec != u.sec || this.process != u.process || this.hostAddr[0] != u.hostAddr[0] || this.hostAddr[1] != u.hostAddr[1];
    }

    public boolean lessThan(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return false;
        }
        if (this.equals(u)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(this)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(u)) {
            return true;
        }
        if (this.hostAddr[0] < u.hostAddr[0] && this.hostAddr[1] < u.hostAddr[1]) {
            return true;
        }
        if (this.hostAddr[0] == u.hostAddr[0] && this.hostAddr[1] == u.hostAddr[1]) {
            if (this.process < u.process) {
                return true;
            }
            if (this.process == u.process) {
                if (this.sec < u.sec) {
                    return true;
                }
                if (this.sec == u.sec && this.other < u.other) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean greaterThan(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return false;
        }
        if (this.equals(u)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(this)) {
            return true;
        }
        if (LAST_RESOURCE_UID.equals(u)) {
            return false;
        }
        if (this.hostAddr[0] > u.hostAddr[0] && this.hostAddr[1] > u.hostAddr[1]) {
            return true;
        }
        if (this.hostAddr[0] == u.hostAddr[0] && this.hostAddr[1] == u.hostAddr[0]) {
            if (this.process > u.process) {
                return true;
            }
            if (this.process == u.process) {
                if (this.sec > u.sec) {
                    return true;
                }
                if (this.sec == u.sec && this.other > u.other) {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean valid() {
        return this._valid;
    }

    public static final Uid nullUid() {
        return NIL_UID;
    }

    public static final Uid lastResourceUid() {
        return LAST_RESOURCE_UID;
    }

    public static final Uid maxUid() {
        return MAX_UID;
    }

    public static final Uid minUid() {
        return MIN_UID;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this._valid) {
            throw new IOException("Invalid Uid object.");
        }
        out.defaultWriteObject();
        out.writeLong(this.hostAddr[0]);
        out.writeLong(this.hostAddr[1]);
        out.writeInt(this.process);
        out.writeInt(this.sec);
        out.writeInt(this.other);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.hostAddr = new long[2];
            this.hostAddr[0] = in.readLong();
            this.hostAddr[1] = in.readLong();
            this.process = in.readInt();
            this.sec = in.readInt();
            this.other = in.readInt();
            this._valid = true;
            this.generateHash();
        }
        catch (IOException e) {
            this._valid = false;
            throw e;
        }
    }

    private static int getValue() {
        int value = 0;
        do {
            if ((value = uidsCreated.getAndIncrement()) != 0x40000000) continue;
            uidsCreated.set(0);
            initTime = (int)(System.currentTimeMillis() / 1000L);
        } while (value >= 0x40000000);
        return value;
    }

    private final void generateHash() {
        if (this._valid) {
            this._hashValue = (int)this.hostAddr[0] ^ (int)this.hostAddr[1] ^ this.process ^ this.sec ^ this.other;
            if (this._hashValue < 0) {
                this._hashValue = -this._hashValue;
            }
        } else {
            tsLogger.i18NLogger.warn_common_Uid_6();
        }
    }

    private static final char getBreakChar(String uidString) {
        if (uidString == null) {
            return ':';
        }
        if (uidString.indexOf(95) != -1) {
            return '_';
        }
        return ':';
    }

    static {
        BE_LONG_ARRAY_VIEW = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        BE_INT_ARRAY_VIEW = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
        BYTE_FORM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Uid.class, byte[].class, "_byteForm");
        NIL_UID = new Uid("0:0:0:0:0");
        LAST_RESOURCE_UID = new Uid("0:0:0:0:1");
        MAX_UID = new Uid("7fffffffffffffff:7fffffffffffffff:7fffffff:7fffffff:7fffffff");
        MIN_UID = new Uid("-8000000000000000:-8000000000000000:-80000000:-80000000:-80000000");
    }
}

