/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliverySource;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliverySourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeliverySourcesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeDeliverySourcesResponse> {
    private static final SdkField<List<DeliverySource>> DELIVERY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deliverySources").getter(DescribeDeliverySourcesResponse.getter(DescribeDeliverySourcesResponse::deliverySources)).setter(DescribeDeliverySourcesResponse.setter(Builder::deliverySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliverySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeliverySource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDeliverySourcesResponse.getter(DescribeDeliverySourcesResponse::nextToken)).setter(DescribeDeliverySourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_SOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeliverySourcesResponse.memberNameToFieldInitializer();
    private final List<DeliverySource> deliverySources;
    private final String nextToken;

    private DescribeDeliverySourcesResponse(BuilderImpl builder) {
        super(builder);
        this.deliverySources = builder.deliverySources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeliverySources() {
        return this.deliverySources != null && !(this.deliverySources instanceof SdkAutoConstructList);
    }

    public final List<DeliverySource> deliverySources() {
        return this.deliverySources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliverySources() ? this.deliverySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliverySourcesResponse)) {
            return false;
        }
        DescribeDeliverySourcesResponse other = (DescribeDeliverySourcesResponse)((Object)obj);
        return this.hasDeliverySources() == other.hasDeliverySources() && Objects.equals(this.deliverySources(), other.deliverySources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeliverySourcesResponse").add("DeliverySources", this.hasDeliverySources() ? this.deliverySources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliverySources": {
                return Optional.ofNullable(clazz.cast(this.deliverySources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deliverySources", DELIVERY_SOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliverySourcesResponse, T> g) {
        return obj -> g.apply((DescribeDeliverySourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<DeliverySource> deliverySources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliverySourcesResponse model) {
            super(model);
            this.deliverySources(model.deliverySources);
            this.nextToken(model.nextToken);
        }

        public final List<DeliverySource.Builder> getDeliverySources() {
            List<DeliverySource.Builder> result = DeliverySourcesCopier.copyToBuilder(this.deliverySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeliverySources(Collection<DeliverySource.BuilderImpl> deliverySources) {
            this.deliverySources = DeliverySourcesCopier.copyFromBuilder(deliverySources);
        }

        @Override
        public final Builder deliverySources(Collection<DeliverySource> deliverySources) {
            this.deliverySources = DeliverySourcesCopier.copy(deliverySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverySources(DeliverySource ... deliverySources) {
            this.deliverySources(Arrays.asList(deliverySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverySources(Consumer<DeliverySource.Builder> ... deliverySources) {
            this.deliverySources(Stream.of(deliverySources).map(c -> (DeliverySource)((DeliverySource.Builder)DeliverySource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDeliverySourcesResponse build() {
            return new DescribeDeliverySourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeliverySourcesResponse> {
        public Builder deliverySources(Collection<DeliverySource> var1);

        public Builder deliverySources(DeliverySource ... var1);

        public Builder deliverySources(Consumer<DeliverySource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

