import { GaussianProcessModel, MiningSchema } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
export const GAUSSIAN_PROCESS_MODEL = `
elements.elements[(name = "GaussianProcessModel")] ~> $map(function($v, $i) {
  $merge([
    $gaussianProcessModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function gaussianProcessModelFactory() {
    return new GaussianProcessModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        TrainingInstances: { InstanceFields: { InstanceField: [] } },
        functionName: "regression",
    });
}
//# sourceMappingURL=GaussianProcessModel.js.map