import { ChannelType, EditorApi, EditorEnvelopeLocator, KogitoEditorChannelApi, KogitoEditorEnvelopeApi } from "../../api";
import * as React from "react";
import { EmbeddedEditorFile, StateControl } from "../../channel";
import { EnvelopeServer } from "@kie-tools-core/envelope-bus/dist/channel";
type Omit<T, K extends keyof T> = Pick<T, Exclude<keyof T, K>>;
type ChannelApiMethodsAlreadyImplementedByEmbeddedEditor = "kogitoEditor_contentRequest";
type EmbeddedEditorChannelApiOverrides = Partial<Omit<KogitoEditorChannelApi, ChannelApiMethodsAlreadyImplementedByEmbeddedEditor>>;
export type Props = EmbeddedEditorChannelApiOverrides & {
    file: EmbeddedEditorFile;
    editorEnvelopeLocator: EditorEnvelopeLocator;
    channelType: ChannelType;
    locale: string;
    customChannelApiImpl?: KogitoEditorChannelApi;
    stateControl?: StateControl;
    isReady?: boolean;
    workspaceRootAbsolutePosixPath?: string;
};
export type EmbeddedEditorRef = EditorApi & {
    isReady: boolean;
    iframeRef: React.RefObject<HTMLIFrameElement>;
    getStateControl(): StateControl;
    getEnvelopeServer(): EnvelopeServer<KogitoEditorChannelApi, KogitoEditorEnvelopeApi>;
    onKeyDown: (ke: React.KeyboardEvent) => void;
};
export declare const EmbeddedEditor: React.ForwardRefExoticComponent<Partial<Omit<KogitoEditorChannelApi, "kogitoEditor_contentRequest">> & {
    file: EmbeddedEditorFile;
    editorEnvelopeLocator: EditorEnvelopeLocator;
    channelType: ChannelType;
    locale: string;
    customChannelApiImpl?: KogitoEditorChannelApi;
    stateControl?: StateControl;
    isReady?: boolean;
    workspaceRootAbsolutePosixPath?: string;
} & React.RefAttributes<EmbeddedEditorRef | undefined>>;
export {};
//# sourceMappingURL=EmbeddedEditor.d.ts.map