import { Parser, ParserRuleContext, Token } from "antlr4";
import { FilterPathExpressionContext, NameRefContext } from "./generated-parser/FEEL_1_1Parser";
import { Type } from "./Type";
import { FeelIdentifiedSymbol } from "../FeelIdentifiedSymbol";
import { FeelSyntacticSymbolNature } from "../FeelSyntacticSymbolNature";
import { FeelSymbol } from "../FeelSymbol";
import { Identifier } from "../Identifier";
export declare class ParserHelper {
    private dynamicResolution;
    private currentScope;
    private readonly currentName;
    private readonly _variables;
    private readonly scopes;
    private readonly _availableSymbols;
    constructor();
    get availableSymbols(): Array<FeelSymbol>;
    get variables(): Array<FeelIdentifiedSymbol>;
    pushScope(type?: Type, allowDynamicVariables?: boolean): void;
    popScope(): void;
    enableDynamicResolution(): void;
    disableDynamicResolution(): void;
    isFeatDMN12EnhancedForLoopEnabled(): boolean;
    startVariable(t: Token): void;
    popName(): void;
    pushName(ctx: ParserRuleContext | string): void;
    private getName;
    defineVariable(variable: string | ParserRuleContext, type?: Type, variableType?: FeelSyntacticSymbolNature, variableSource?: Identifier, allowDynamicVariables?: boolean): void;
    dismissScope(): void;
    recoverScope(name?: string): void;
    followUp(token: Token, isPredict: boolean): boolean;
    isDynamicResolution(): boolean;
    validateVariable(_n1: NameRefContext, qn: String[], name: string): void;
    getOriginalText(ctx: ParserRuleContext): string;
    fphEnd(count: number): number;
    fphStart(_n1: FilterPathExpressionContext, param2: Parser): number;
}
//# sourceMappingURL=ParserHelper.d.ts.map