import { getDecisionServicePropertiesRelativeToThisDmn } from "../../mutations/addExistingDecisionServiceToDrd";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
export function computeContainingDecisionServiceHrefsByDecisionHrefs({ thisDmnsNamespace, drgElementsByNamespace, }) {
    var _a, _b;
    const decisionServiceHrefsByDecisionHrefs = new Map();
    for (const [drgElementsNamespace, drgElements] of drgElementsByNamespace) {
        for (const drgElement of drgElements !== null && drgElements !== void 0 ? drgElements : []) {
            const drgElementHref = buildXmlHref({
                namespace: drgElementsNamespace === thisDmnsNamespace ? "" : drgElementsNamespace,
                id: drgElement["@_id"],
            });
            if (drgElement.__$$element === "decision") {
                decisionServiceHrefsByDecisionHrefs.set(drgElementHref, (_a = decisionServiceHrefsByDecisionHrefs.get(drgElementHref)) !== null && _a !== void 0 ? _a : []);
            }
            else if (drgElement.__$$element === "decisionService") {
                const { containedDecisionHrefsRelativeToThisDmn } = getDecisionServicePropertiesRelativeToThisDmn({
                    thisDmnsNamespace,
                    decisionServiceNamespace: drgElementsNamespace,
                    decisionService: drgElement,
                });
                for (const containedDecisionHref of containedDecisionHrefsRelativeToThisDmn) {
                    decisionServiceHrefsByDecisionHrefs.set(containedDecisionHref, [
                        ...((_b = decisionServiceHrefsByDecisionHrefs.get(containedDecisionHref)) !== null && _b !== void 0 ? _b : []),
                        drgElementHref,
                    ]);
                }
            }
            else {
            }
        }
    }
    return decisionServiceHrefsByDecisionHrefs;
}
//# sourceMappingURL=computeContainingDecisionServiceHrefsByDecisionHrefs.ts.js.map