import { normalize } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { enableMapSet } from "immer";
import { create } from "zustand";
import { immer } from "zustand/middleware/immer";
import { computeAllFeelVariableUniqueNames } from "./computed/computeAllFeelVariableUniqueNames";
import { computeDataTypes } from "./computed/computeDataTypes";
import { computeDiagramData } from "./computed/computeDiagramData";
import { computeDirectlyIncludedExternalModelsByNamespace } from "./computed/computeDirectlyIncludedExternalModelsByNamespace";
import { computeImportsByNamespace } from "./computed/computeImportsByNamespace";
import { computeIndexedDrd } from "./computed/computeIndexes";
import { computeIsDropTargetNodeValidForSelection } from "./computed/computeIsDropTargetNodeValidForSelection";
import { DEFAULT_VIEWPORT } from "../diagram/Diagram";
import { computeExternalDmnModelsByNamespaceMap } from "./computed/computeExternalDmnModelsByNamespaceMap";
enableMapSet();
export var DiagramLhsPanel;
(function (DiagramLhsPanel) {
    DiagramLhsPanel["NONE"] = "NONE";
    DiagramLhsPanel["DRD_SELECTOR"] = "DRD_SELECTOR";
    DiagramLhsPanel["DRG_NODES"] = "DRG_NODES";
    DiagramLhsPanel["EXTERNAL_NODES"] = "EXTERNAL_NODES";
})(DiagramLhsPanel || (DiagramLhsPanel = {}));
export var DmnEditorTab;
(function (DmnEditorTab) {
    DmnEditorTab[DmnEditorTab["EDITOR"] = 0] = "EDITOR";
    DmnEditorTab[DmnEditorTab["DATA_TYPES"] = 1] = "DATA_TYPES";
    DmnEditorTab[DmnEditorTab["INCLUDED_MODELS"] = 2] = "INCLUDED_MODELS";
})(DmnEditorTab || (DmnEditorTab = {}));
export const defaultStaticState = () => ({
    boxedExpressionEditor: {
        activeDrgElementId: undefined,
        selectedObjectId: undefined,
        propertiesPanel: {
            isOpen: false,
        },
    },
    navigation: {
        tab: DmnEditorTab.EDITOR,
    },
    focus: {
        consumableId: undefined,
    },
    dataTypesEditor: {
        activeItemDefinitionId: undefined,
        expandedItemComponentIds: [],
    },
    diagram: {
        autoLayout: {
            canAutoGenerateDrd: false,
        },
        __unsafeDrdIndex: 0,
        edgeIdBeingUpdated: undefined,
        dropTargetNode: undefined,
        ongoingConnection: undefined,
        propertiesPanel: {
            isOpen: false,
            elementId: undefined,
        },
        overlaysPanel: {
            isOpen: false,
        },
        openLhsPanel: DiagramLhsPanel.NONE,
        overlays: {
            enableNodeHierarchyHighlight: false,
            enableCustomNodeStyles: true,
            enableDataTypesToolbarOnNodes: true,
            enableEvaluationHighlights: false,
        },
        snapGrid: {
            isEnabled: true,
            x: 20,
            y: 20,
        },
        _selectedNodes: [],
        _selectedEdges: [],
        draggingNodes: [],
        resizingNodes: [],
        draggingWaypoints: [],
        movingDividerLines: [],
        isEditingStyle: false,
        viewport: DEFAULT_VIEWPORT,
    },
});
export function createDmnEditorStore(model, computedCache) {
    const { diagram, ...defaultState } = defaultStaticState();
    return create(immer(() => {
        var _a;
        return ({
            dmn: {
                model: normalize(model),
            },
            ...defaultState,
            diagram: {
                ...diagram,
                autoLayout: {
                    canAutoGenerateDrd: ((_a = model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === undefined &&
                        model.definitions.drgElement !== undefined,
                },
            },
            dispatch(s) {
                return {
                    dmn: {
                        reset: () => {
                            s.diagram._selectedNodes = [];
                            s.diagram.draggingNodes = [];
                            s.diagram.resizingNodes = [];
                            s.navigation.tab = DmnEditorTab.EDITOR;
                            s.boxedExpressionEditor.activeDrgElementId = undefined;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                        },
                    },
                    boxedExpressionEditor: {
                        open: (id) => {
                            s.boxedExpressionEditor.activeDrgElementId = id;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                            s.boxedExpressionEditor.propertiesPanel.isOpen = s.diagram.propertiesPanel.isOpen;
                        },
                        close: () => {
                            s.diagram.propertiesPanel.isOpen = s.boxedExpressionEditor.propertiesPanel.isOpen;
                            s.boxedExpressionEditor.activeDrgElementId = undefined;
                            s.boxedExpressionEditor.selectedObjectId = undefined;
                        },
                    },
                    diagram: {
                        setNodeStatus: (nodeId, newStatus) => {
                            if (newStatus.selected !== undefined) {
                                if (newStatus.selected) {
                                    s.diagram._selectedNodes.push(nodeId);
                                }
                                else {
                                    s.diagram._selectedNodes = s.diagram._selectedNodes.filter((s) => s !== nodeId);
                                }
                            }
                            if (newStatus.dragging !== undefined) {
                                if (newStatus.dragging) {
                                    s.diagram.draggingNodes.push(nodeId);
                                }
                                else {
                                    s.diagram.draggingNodes = s.diagram.draggingNodes.filter((s) => s !== nodeId);
                                }
                            }
                            if (newStatus.resizing !== undefined) {
                                if (newStatus.resizing) {
                                    s.diagram.resizingNodes.push(nodeId);
                                }
                                else {
                                    s.diagram.resizingNodes = s.diagram.resizingNodes.filter((s) => s !== nodeId);
                                }
                            }
                        },
                        setEdgeStatus: (edgeId, newStatus) => {
                            if (newStatus.selected !== undefined) {
                                if (newStatus.selected) {
                                    s.diagram._selectedEdges.push(edgeId);
                                }
                                else {
                                    s.diagram._selectedEdges = s.diagram._selectedEdges.filter((s) => s !== edgeId);
                                }
                            }
                            if (newStatus.draggingWaypoint !== undefined) {
                                if (newStatus.draggingWaypoint) {
                                    s.diagram.draggingWaypoints.push(edgeId);
                                }
                                else {
                                    s.diagram.draggingWaypoints = s.diagram.draggingWaypoints.filter((s) => s !== edgeId);
                                }
                            }
                        },
                        setDividerLineStatus: (decisionServiceId, newStatus) => {
                            if (newStatus.moving !== undefined) {
                                if (newStatus.moving) {
                                    s.diagram.movingDividerLines.push(decisionServiceId);
                                }
                                else {
                                    s.diagram.movingDividerLines = s.diagram.movingDividerLines.filter((s) => s !== decisionServiceId);
                                }
                            }
                        },
                    },
                };
            },
            computed(s) {
                return {
                    isDiagramEditingInProgress: () => {
                        return computedCache.cached("isDiagramEditingInProgress", (draggingNodesCount, resizingNodesCount, draggingWaypointsCount, movingDividerLinesCount, isisEditingStyle) => draggingNodesCount > 0 ||
                            resizingNodesCount > 0 ||
                            draggingWaypointsCount > 0 ||
                            movingDividerLinesCount > 0 ||
                            isisEditingStyle, [
                            s.diagram.draggingNodes.length,
                            s.diagram.resizingNodes.length,
                            s.diagram.draggingWaypoints.length,
                            s.diagram.movingDividerLines.length,
                            s.diagram.isEditingStyle,
                        ]);
                    },
                    indexedDrd: () => {
                        return computedCache.cached("indexedDrd", computeIndexedDrd, [
                            s.dmn.model.definitions["@_namespace"],
                            s.dmn.model.definitions,
                            s.computed(s).getDrdIndex(),
                        ]);
                    },
                    importsByNamespace: () => {
                        return computedCache.cached("importsByNamespace", computeImportsByNamespace, [
                            s.dmn.model.definitions.import,
                        ]);
                    },
                    isAlternativeInputDataShape: () => {
                        var _a;
                        return computedCache.cached("isAlternativeInputDataShape", (drdIndex, dmnDiagram) => { var _a, _b; return (_b = (_a = dmnDiagram === null || dmnDiagram === void 0 ? void 0 : dmnDiagram[drdIndex]) === null || _a === void 0 ? void 0 : _a["@_useAlternativeInputDataShape"]) !== null && _b !== void 0 ? _b : false; }, [s.computed(s).getDrdIndex(), (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]]);
                    },
                    isDropTargetNodeValidForSelection: (externalModelsByNamespace) => computedCache.cached("isDropTargetNodeValidForSelection", computeIsDropTargetNodeValidForSelection, [
                        s.diagram.dropTargetNode,
                        s.computed(s).getDiagramData(externalModelsByNamespace),
                    ]),
                    getDrdIndex: () => {
                        var _a;
                        return computedCache.cached("getDrdIndex", (__unsafeDrdIndex, dmnDiagram) => (dmnDiagram === null || dmnDiagram === void 0 ? void 0 : dmnDiagram.length) && __unsafeDrdIndex > dmnDiagram.length - 1
                            ? dmnDiagram.length - 1
                            : __unsafeDrdIndex, [s.diagram.__unsafeDrdIndex, (_a = s.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]]);
                    },
                    getDataTypes: (externalModelsByNamespace) => computedCache.cached("getDataTypes", computeDataTypes, [
                        s.dmn.model.definitions["@_namespace"],
                        s.dmn.model.definitions.itemDefinition,
                        s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace),
                        s.computed(s).importsByNamespace(),
                    ]),
                    getAllFeelVariableUniqueNames: () => computedCache.cached("getAllFeelVariableUniqueNames", computeAllFeelVariableUniqueNames, [
                        s.dmn.model.definitions.drgElement,
                        s.dmn.model.definitions.import,
                    ]),
                    getDirectlyIncludedExternalModelsByNamespace: (externalModelsByNamespace) => computedCache.cached("getDirectlyIncludedExternalModelsByNamespace", computeDirectlyIncludedExternalModelsByNamespace, [s.dmn.model.definitions.import, externalModelsByNamespace]),
                    getDiagramData: (externalModelsByNamespace) => computedCache.cached("getDiagramData", computeDiagramData, [
                        s.diagram,
                        s.dmn.model.definitions,
                        s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace),
                        s.computed(s).indexedDrd(),
                        s.computed(s).isAlternativeInputDataShape(),
                    ]),
                    getExternalDmnModelsByNamespaceMap: (externalModelsByNamespace) => computedCache.cached("getExternalDmnModelsByNamespaceMap", computeExternalDmnModelsByNamespaceMap, [
                        s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                    ]),
                };
            },
        });
    }));
}
//# sourceMappingURL=Store.js.map