import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { Form, FormSection, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { DataSourceIcon } from "@patternfly/react-icons/dist/js/icons/data-source-icon";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useState } from "react";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { SyncAltIcon } from "@patternfly/react-icons/dist/js/icons/sync-alt-icon";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import { useSettings } from "../settings/DmnEditorSettingsContext";
export function GlobalDiagramProperties() {
    var _a;
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const [isGlobalSectionExpanded, setGlobalSectionExpanded] = useState(true);
    const [isIdNamespaceSectionExpanded, setIdNamespaceSectionExpanded] = useState(true);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const [regenerateIdConfirmationModal, setRegenerateIdConfirmationModal] = useState(false);
    return (_jsxs(Form, { children: [_jsx(FormSection, { title: _jsx(PropertiesPanelHeader, { expands: true, fixed: true, isSectionExpanded: isGlobalSectionExpanded, toogleSectionExpanded: () => setGlobalSectionExpanded((prev) => !prev), icon: _jsx(DataSourceIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), title: "Global properties", action: _jsx(Button, { title: "Close", variant: ButtonVariant.plain, onClick: () => {
                            dmnEditorStoreApi.setState((state) => {
                                state.diagram.propertiesPanel.isOpen = false;
                            });
                        }, children: _jsx(TimesIcon, {}) }) }), children: isGlobalSectionExpanded && (_jsx(_Fragment, { children: _jsxs(FormSection, { style: { paddingLeft: "20px" }, children: [_jsx(FormGroup, { label: "Name", children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: thisDmn.model.definitions["@_id"], name: thisDmn.model.definitions["@_name"], isReadOnly: settings.isReadOnly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: (newName) => {
                                        dmnEditorStoreApi.setState((state) => {
                                            state.dmn.model.definitions["@_name"] = newName;
                                        });
                                    }, allUniqueNames: () => new Map() }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: settings.isReadOnly, style: { resize: "vertical", minHeight: "40px" }, rows: 6, placeholder: "Enter a description...", value: (_a = thisDmn.model.definitions.description) === null || _a === void 0 ? void 0 : _a.__$$text, onChange: (newDescription) => dmnEditorStoreApi.setState((state) => {
                                        state.dmn.model.definitions.description = { __$$text: newDescription };
                                    }) }) }), _jsx(FormGroup, { label: "Expression language", children: _jsx(TextInput, { "aria-label": "Expression language", type: "text", isDisabled: settings.isReadOnly, placeholder: "Enter an expression language...", value: thisDmn.model.definitions["@_expressionLanguage"], onChange: (newExprLang) => dmnEditorStoreApi.setState((state) => {
                                        state.dmn.model.definitions["@_expressionLanguage"] = newExprLang;
                                    }) }) })] }) })) }), _jsx(FormSection, { style: { paddingTop: "20px" }, title: _jsx(PropertiesPanelHeader, { expands: true, isSectionExpanded: isIdNamespaceSectionExpanded, toogleSectionExpanded: () => setIdNamespaceSectionExpanded((prev) => !prev), title: "ID & Namespace", action: _jsx(Button, { title: "Re-generate ID & Namespace", variant: ButtonVariant.plain, isDisabled: settings.isReadOnly, onClick: () => setRegenerateIdConfirmationModal(true), style: { paddingBottom: 0, paddingTop: 0 }, children: _jsx(SyncAltIcon, {}) }) }), children: isIdNamespaceSectionExpanded && (_jsx(_Fragment, { children: _jsxs(FormSection, { style: { paddingLeft: "20px", marginTop: 0 }, children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { placeholder: "Enter a diagram ID...", isReadOnly: settings.isReadOnly, hoverTip: "Copy", clickTip: "Copied", onChange: (newId) => {
                                        dmnEditorStoreApi.setState((state) => {
                                            state.dmn.model.definitions["@_id"] = `${newId}`;
                                        });
                                    }, children: thisDmn.model.definitions["@_id"] }) }), _jsx(FormGroup, { label: "Namespace", children: _jsx(ClipboardCopy, { placeholder: "Enter a diagram Namespace...", isReadOnly: settings.isReadOnly, hoverTip: "Copy", clickTip: "Copied", onChange: (newNamespace) => {
                                        dmnEditorStoreApi.setState((state) => {
                                            state.dmn.model.definitions["@_namespace"] = `${newNamespace}`;
                                        });
                                    }, children: thisDmn.model.definitions["@_namespace"] }) })] }) })) }), _jsxs(Modal, { "aria-labelledby": "Regenerate ID & Namespace", variant: ModalVariant.small, isOpen: regenerateIdConfirmationModal, onClose: () => setRegenerateIdConfirmationModal(false), actions: [
                    _jsx(Button, { variant: ButtonVariant.primary, isDisabled: settings.isReadOnly, onClick: () => {
                            setRegenerateIdConfirmationModal(false);
                            dmnEditorStoreApi.setState((state) => {
                                state.dmn.model.definitions["@_id"] = generateUuid();
                                state.dmn.model.definitions["@_namespace"] = `https://kie.apache.org/dmn/${generateUuid()}`;
                            });
                        }, children: "Yes, re-generate ID and Namespace" }, "confirm"),
                    _jsx(Button, { variant: "link", onClick: () => setRegenerateIdConfirmationModal(false), children: "Cancel" }, "cancel"),
                ], children: ["Re-generating the ID and Namespace of a DMN file will potentially break other DMN files that depend on it.", _jsx("br", {}), _jsx("br", {}), "Are you sure you want to continue?"] })] }));
}
//# sourceMappingURL=GlobalDiagramProperties.js.map