import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { computeDiagramData } from "../store/computed/computeDiagramData";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { computeIndexedDrd } from "../store/computed/computeIndexes";
import { getDefaultDrdName } from "../mutations/addOrGetDrd";
import { addShape } from "../mutations/addShape";
import { addEdge } from "../mutations/addEdge";
import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
export async function autoGenerateDrd(args) {
    var _a;
    args.model.definitions["dmndi:DMNDI"] = {
        ...args.model.definitions["dmndi:DMNDI"],
        "dmndi:DMNDiagram": [
            {
                "@_id": generateUuid(),
                "@_name": getDefaultDrdName({ drdIndex: 0 }),
                "@_useAlternativeInputDataShape": false,
                "dmndi:DMNDiagramElement": [],
                "di:extension": { "kie:ComponentsWidthsExtension": { "kie:ComponentWidths": [{}] } },
            },
        ],
    };
    (_a = args.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a.forEach((drgElement) => {
        var _a;
        const nodeType = (_a = getNodeTypeFromDmnObject(drgElement)) !== null && _a !== void 0 ? _a : "node_unknown";
        const minNodeSize = MIN_NODE_SIZES[nodeType]({
            snapGrid: {
                isEnabled: true,
                x: 20,
                y: 20,
            },
            isAlternativeInputDataShape: false,
        });
        addShape({
            definitions: args.model.definitions,
            drdIndex: 0,
            nodeType: nodeType,
            shape: {
                "@_id": generateUuid(),
                "@_dmnElementRef": drgElement["@_id"],
                "dc:Bounds": {
                    "@_x": 0,
                    "@_y": 0,
                    ...minNodeSize,
                },
            },
        });
    });
    const definedNamespaces = new Map(Object.keys(args.model.definitions)
        .filter((keys) => String(keys).startsWith("@_xmlns:"))
        .map((xmlnsKey) => [
        args.model.definitions[xmlnsKey],
        xmlnsKey.split("@_xmlns:")[1],
    ]));
    const updateIndexedDrdWithNodes = computeIndexedDrd(args.model.definitions["@_namespace"], args.model.definitions, 0);
    const { nodesById: updatedNodesByIdWithNodes, drgEdges: updatedDrgEdgesWithNodes } = computeDiagramData(args.diagram, args.model.definitions, args.externalModelTypesByNamespace, updateIndexedDrdWithNodes, false);
    const externalNodesHref = updatedDrgEdgesWithNodes.reduce((acc, drgEdge) => {
        if (!updatedNodesByIdWithNodes.has(drgEdge.sourceId)) {
            acc.add(drgEdge.sourceId);
        }
        if (!updatedNodesByIdWithNodes.has(drgEdge.targetId)) {
            acc.add(drgEdge.targetId);
        }
        return acc;
    }, new Set());
    externalNodesHref.forEach((href) => {
        var _a, _b;
        const { namespace, id } = parseXmlHref(href);
        if (namespace) {
            const externalModel = (_a = args.externalModelsByNamespace) === null || _a === void 0 ? void 0 : _a[namespace];
            if (externalModel && externalModel.model.definitions) {
                const drgElements = externalModel.model.definitions.drgElement;
                const drgElement = drgElements === null || drgElements === void 0 ? void 0 : drgElements.filter((drgElement) => drgElement["@_id"] === id);
                const nodeType = (_b = getNodeTypeFromDmnObject(drgElement[0])) !== null && _b !== void 0 ? _b : "node_unknown";
                const minNodeSize = MIN_NODE_SIZES[nodeType]({
                    snapGrid: {
                        isEnabled: true,
                        x: 20,
                        y: 20,
                    },
                    isAlternativeInputDataShape: false,
                });
                addShape({
                    definitions: args.model.definitions,
                    drdIndex: 0,
                    nodeType: nodeType,
                    shape: {
                        "@_id": generateUuid(),
                        "@_dmnElementRef": `${definedNamespaces.get(namespace)}:${id}`,
                        "dc:Bounds": {
                            "@_x": 0,
                            "@_y": 0,
                            ...minNodeSize,
                        },
                    },
                });
            }
        }
    });
    const updatedIndexedDrdWithExternalNodes = computeIndexedDrd(args.model.definitions["@_namespace"], args.model.definitions, 0);
    const { nodesById: updatedNodesByIdWithExternalNodes, edgesById: updatedEdgesByIdWithExternalNodes, drgEdges: updatedDrgEdgesWithExternalNodes, } = computeDiagramData(args.diagram, args.model.definitions, args.externalModelTypesByNamespace, updatedIndexedDrdWithExternalNodes, false);
    for (const drgEdge of updatedDrgEdgesWithExternalNodes) {
        const edge = updatedEdgesByIdWithExternalNodes.get(drgEdge.id);
        const sourceNode = updatedNodesByIdWithExternalNodes.get(drgEdge.sourceId);
        const targetNode = updatedNodesByIdWithExternalNodes.get(drgEdge.targetId);
        if (!edge || !sourceNode || !targetNode) {
            continue;
        }
        addEdge({
            definitions: args.model.definitions,
            drdIndex: 0,
            keepWaypoints: false,
            edge: {
                autoPositionedEdgeMarker: undefined,
                type: edge.type,
                targetHandle: PositionalNodeHandleId.Bottom,
                sourceHandle: PositionalNodeHandleId.Top,
            },
            sourceNode: {
                type: sourceNode.type,
                href: sourceNode.id,
                data: sourceNode.data,
                bounds: sourceNode.data.shape["dc:Bounds"],
                shapeId: sourceNode.data.shape["@_id"],
            },
            targetNode: {
                type: targetNode.type,
                href: targetNode.id,
                data: targetNode.data,
                bounds: targetNode.data.shape["dc:Bounds"],
                index: targetNode.data.index,
                shapeId: targetNode.data.shape["@_id"],
            },
            externalModelsByNamespace: args.externalModelsByNamespace,
        });
    }
}
//# sourceMappingURL=autoGenerateDrd.js.map