import { getXmlNamespaceDeclarationName } from "@kie-tools/dmn-marshaller/dist/xml/xmlNamespaceDeclarations";
import { computeDiagramData } from "../store/computed/computeDiagramData";
import { deleteNode, NodeDeletionMode } from "./deleteNode";
import { nodeNatures } from "./NodeNature";
import { deleteEdge, EdgeDeletionMode } from "./deleteEdge";
import { computeIndexedDrd } from "../store/computed/computeIndexes";
import { defaultStaticState } from "../store/Store";
export function deleteImport({ definitions, __readonly_index, __readonly_externalModelTypesByNamespace, __readonly_externalModelsByNamespace, }) {
    var _a, _b, _c;
    (_a = definitions.import) !== null && _a !== void 0 ? _a : (definitions.import = []);
    const [deletedImport] = definitions.import.splice(__readonly_index, 1);
    const namespaceName = getXmlNamespaceDeclarationName({
        rootElement: definitions,
        namespace: deletedImport["@_namespace"],
    });
    const defaultDiagram = defaultStaticState().diagram;
    (_c = (_b = definitions["dmndi:DMNDI"]) === null || _b === void 0 ? void 0 : _b["dmndi:DMNDiagram"]) === null || _c === void 0 ? void 0 : _c.forEach((_, i) => {
        var _a, _b;
        const indexedDrd = computeIndexedDrd(definitions["@_namespace"], definitions, i);
        const { externalNodesByNamespace, drgEdges, edgesFromExternalNodesByNamespace } = computeDiagramData(defaultDiagram, definitions, __readonly_externalModelTypesByNamespace, indexedDrd, false);
        (_a = externalNodesByNamespace.get(deletedImport["@_namespace"])) === null || _a === void 0 ? void 0 : _a.forEach((node) => {
            var _a;
            deleteNode({
                definitions,
                __readonly_drgEdges: drgEdges,
                __readonly_drdIndex: 0,
                __readonly_nodeNature: nodeNatures[node.type],
                __readonly_dmnObjectId: (_a = node.data.dmnObject) === null || _a === void 0 ? void 0 : _a["@_id"],
                __readonly_dmnObjectQName: node.data.dmnObjectQName,
                __readonly_dmnObjectNamespace: node.data.dmnObjectNamespace,
                __readonly_externalDmnsIndex: __readonly_externalModelTypesByNamespace.dmns,
                __readonly_mode: NodeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                __readonly_externalModelsByNamespace,
            });
        });
        (_b = edgesFromExternalNodesByNamespace.get(deletedImport["@_namespace"])) === null || _b === void 0 ? void 0 : _b.forEach((edge) => {
            deleteEdge({
                definitions,
                drdIndex: 0,
                edge: { id: edge.id, dmnObject: edge.data.dmnObject },
                mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                externalModelsByNamespace: __readonly_externalModelsByNamespace,
            });
        });
    });
    if (namespaceName) {
        delete definitions[`@_xmlns:${namespaceName}`];
    }
}
//# sourceMappingURL=deleteImport.js.map