import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useState } from "react";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { DiagramLhsPanel, DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { DmnObjectListItem } from "./DmnObjectListItem";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER } from "../includedModels/IncludedModels";
import { useDmnEditor } from "../DmnEditorContext";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export const MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS = "kie-dmn-editor--external-node-from-included-models";
export function ExternalNodesPanel() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const { externalModelsByNamespace } = useExternalModels();
    const externalDmnsByNamespace = useDmnEditorStore((s) => s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns);
    const dmnShapesByHref = useDmnEditorStore((s) => s.computed(s).indexedDrd().dmnShapesByHref);
    const { onRequestToResolvePath } = useDmnEditor();
    const onDragStart = useCallback((event, externalNode) => {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_EXTERNAL_NODES_FROM_INCLUDED_MODELS, JSON.stringify(externalNode));
        event.dataTransfer.effectAllowed = "move";
    }, []);
    const [filter, setFilter] = useState("");
    return (_jsxs(_Fragment, { children: [externalDmnsByNamespace.size === 0 && (_jsx(_Fragment, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { size: "md", headingLevel: "h4", children: "No external nodes available" }), _jsx(EmptyStateBody, { children: "Maybe the included models have no exported nodes, or there are no included models." }), _jsx("br", {}), _jsx(EmptyStatePrimary, { children: _jsx(Button, { variant: ButtonVariant.link, onClick: () => dmnEditorStoreApi.setState((state) => {
                                    state.navigation.tab = DmnEditorTab.INCLUDED_MODELS;
                                }), children: "Include model..." }) })] }) })), externalDmnsByNamespace.size > 0 && (_jsxs(_Fragment, { children: [_jsxs("div", { className: "kie-dmn-editor--sticky-top-glass-header", style: { padding: "12px" }, children: [_jsxs(Flex, { justifyContent: { default: "justifyContentSpaceBetween" }, children: [_jsx(TextContent, { children: _jsx(Text, { component: "h3", children: "External nodes" }) }), _jsx(Button, { title: "Close", variant: ButtonVariant.plain, onClick: () => dmnEditorStoreApi.setState((state) => {
                                            state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                        }), children: _jsx(TimesIcon, {}) })] }), _jsx(Divider, { style: { marginBottom: "12px" } }), _jsx(SearchInput, { style: { marginBottom: "12px", height: "36px" }, onKeyDown: (e) => e.stopPropagation(), autoFocus: true, placeholder: "Filter...", value: filter, onChange: (_event, value) => setFilter(value), onClear: () => setFilter("") })] }), _jsx("div", { style: { padding: "12px" }, children: [...externalDmnsByNamespace.entries()].flatMap(([namespace, externalDmn]) => {
                            var _a, _b, _c, _d;
                            const externalDmnDefinitions = externalDmn.model.definitions;
                            const _import = importsByNamespace.get(namespace);
                            if (!_import) {
                                console.debug(`DMN EDITOR: Couldn't find import for namespace '${namespace}', although there's an external DMN referencing it.`);
                                return [];
                            }
                            const nodes = (_a = externalDmnDefinitions.drgElement) === null || _a === void 0 ? void 0 : _a.filter((drgElement) => drgElement["@_name"].toLowerCase().includes(filter.toLowerCase())).map((drgElement) => {
                                const dmnObjectHref = buildXmlHref({ namespace, id: drgElement["@_id"] });
                                const isAlreadyIncluded = dmnShapesByHref.has(dmnObjectHref);
                                return (_jsx("div", { className: "kie-dmn-editor--external-nodes-list-item", draggable: !isAlreadyIncluded, style: { opacity: isAlreadyIncluded ? "0.4" : undefined }, onDragStart: (event) => onDragStart(event, {
                                        externalDrgElementNamespace: namespace,
                                        externalDrgElementId: drgElement["@_id"],
                                    }), "data-testid": `kie-tools--dmn-editor--external-node-${_import["@_name"] === "" ? _import["@_id"] : _import["@_name"]}-${drgElement["@_name"]}`, children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" }, children: _jsx(DmnObjectListItem, { dmnObjectHref: dmnObjectHref, dmnObject: drgElement, namespace: namespace, relativeToNamespace: namespace }) }) }, drgElement["@_id"]));
                            });
                            if (((_b = nodes === null || nodes === void 0 ? void 0 : nodes.length) !== null && _b !== void 0 ? _b : 0) <= 0) {
                                return [];
                            }
                            return (_jsxs("div", { className: "kie-dmn-editor--external-nodes-section", children: [_jsxs("div", { className: "kie-dmn-editor--external-nodes-section-title", children: [_jsx("b", { children: `${externalDmnDefinitions["@_name"]}` }), " ", `(`, _import["@_name"] || _jsx("i", { style: { color: "gray" }, children: EMPTY_IMPORT_NAME_NAMESPACE_IDENTIFIER }), `)`, _jsx("br", {}), _jsx("small", { children: _jsx("i", { children: (_d = (_c = onRequestToResolvePath === null || onRequestToResolvePath === void 0 ? void 0 : onRequestToResolvePath(externalDmn.normalizedPosixPathRelativeToTheOpenFile)) !== null && _c !== void 0 ? _c : externalDmn.normalizedPosixPathRelativeToTheOpenFile) !== null && _d !== void 0 ? _d : "" }) })] }), nodes] }, externalDmnDefinitions["@_id"]));
                        }) })] }))] }));
}
//# sourceMappingURL=ExternalNodesPanel.js.map