import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { OffIcon, OnIcon } from "@patternfly/react-icons/dist/js/icons";
export function EvaluationHighlightsBadge() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const isEvaluationHighlightsEnabled = useDmnEditorStore((s) => s.diagram.overlays.enableEvaluationHighlights);
    return (_jsx("aside", { className: "kie-dmn-editor--evaluation-highlights-panel-toggle", children: _jsxs(Label, { icon: isEvaluationHighlightsEnabled ? _jsx(OnIcon, {}) : _jsx(OffIcon, {}), color: isEvaluationHighlightsEnabled ? "purple" : "grey", onClick: () => {
                dmnEditorStoreApi.setState((state) => {
                    state.diagram.overlays.enableEvaluationHighlights = !state.diagram.overlays.enableEvaluationHighlights;
                });
            }, title: "Evaluation highlights", children: ["Evaluation highlights: ", dmnEditorStoreApi.getState().diagram.overlays.enableEvaluationHighlights ? "on" : "off"] }) }));
}
//# sourceMappingURL=EvaluationHighlightsBadge.js.map